# Unify Compliance - Agent Guide

This repository contains the "Unify Compliance" WordPress plugin. Agents operating in this codebase should adhere to the following guidelines.

## Project Structure

- **Type:** WordPress Plugin
- **Root:** Contains main plugin file `unify-compliance.php` and `readme.txt`.
- **Directories:**
  - `admin/`: Admin dashboard UI, assets (JS/CSS), and views.
  - `includes/`: Core PHP logic, classes, and modules (GDPR, NIS2, AI Act).
  - `public/`: Public-facing assets and functionality.
  - `tests/`: Custom PHP test runner.

## Build & Test Commands

### Testing
The project uses a custom PHP test script located in `tests/run-tests.php`. It attempts to bootstrap WordPress by looking for `wp-load.php` four levels up.

- **Run All Tests:**
  ```bash
  php tests/run-tests.php
  ```
  *Note: Ensure the plugin is located in a WordPress plugins directory (`wp-content/plugins/unify-compliance`) for the test runner to find `wp-load.php`.*

- **Running Individual Tests:**
  The test runner executes all tests in sequence. To run a specific section, you may need to temporarily comment out other sections in `tests/run-tests.php` or create a temporary test script based on it.

### Linting
No specific linter configuration is present. Adhere to **WordPress Coding Standards**.
- **PHP:** Use standard WordPress PHP styles.
- **JS/CSS:** Ensure assets in `admin/assets/` are properly enqueued.

### Build
There is no build step (e.g., no Webpack/Rollup). PHP and JS files are used directly.

## Code Style & Conventions

### PHP Conventions
- **Naming:**
  - **Classes:** `Unify_PascalCase` (e.g., `Unify_Core`, `Unify_Module_Manager`).
  - **Methods/Functions:** `snake_case` (e.g., `register_admin_menu`, `is_module_active`).
  - **Constants:** `UPPER_CASE` with `Unify_` prefix (e.g., `Unify_VERSION`, `Unify_PLUGIN_DIR`).
  - **Files:** `class-unify-classname.php` (kebab-case) inside `includes/`.
- **Formatting:**
  - Follow WordPress PHP coding standards (Tabs for indentation, spaces around operators).
  - Open braces on the same line.
- **Architecture:**
  - Use singleton pattern for main classes where appropriate (e.g., `Unify_Core::run()`).
  - Logic is modularized (e.g., `includes/gdpr/`, `includes/nis2/`).
  - Admin views are separated in `admin/views/` and rendered via `unify_get_view()`.

### Database
- Use global `$wpdb` for database operations.
- Table names are prefixed (e.g., `unify_consent_logs`, `unify_dsar_requests`).
- Always use `$wpdb->prepare()` for safe SQL execution.

### JavaScript
- Located in `admin/assets/js/`.
- Uses jQuery as `$` (standard WP pattern).
- Localized variables are passed via `wp_localize_script` (object name `unify_vars`).

### Security
- **Nonce Checks:** Always verify nonces in AJAX handlers and form submissions (`check_ajax_referer`, `wp_verify_nonce`).
- **Permissions:** Check capabilities (e.g., `current_user_can('manage_options')`).
- **Sanitization:** Sanitize all inputs (`sanitize_text_field`, `sanitize_email`, etc.) and escape all outputs (`esc_html`, `esc_attr`).

## Development Workflow

1. **Modules:** New compliance features should be added as modules in `includes/` (like `nis2`, `gdpr`).
2. **Registration:** Register new modules in `Unify_Module_Manager`.
3. **UI:** Add menu pages in `unify_register_admin_menu` and corresponding views in `admin/views/`.
4. **Assets:** Enqueue scripts/styles in `unify_enqueue_admin_assets`.

## Error Handling
- Use `try-catch` blocks where appropriate, especially for external API calls or critical operations.
- Log errors using `error_log()` or a custom logger if available (`Unify_Security_Logger`).
