# Unify Compliance

**One Dashboard. All Regulations.**

Unify Compliance is a comprehensive WordPress plugin that consolidates multiple regulatory compliance frameworks into a single, unified dashboard. Manage GDPR, NIS2, EU AI Act, CCPA, and LGPD compliance from one place—eliminating plugin conflicts, reducing security vulnerabilities, and streamlining your audit trail.

## Features

### 🛡️ GDPR Compliance (Free)
- **Cookie Consent Banner** - Customizable, GDPR-compliant cookie banner with consent tracking
- **Consent Management** - Track and manage user consent preferences with detailed analytics
- **DSAR Forms** - Data Subject Access Request forms for user data requests
- **DSAR Queue** - Manage and process data requests with verification workflows
- **Privacy Policy Integration** - Seamless integration with WordPress privacy pages

### 🔒 NIS2 Compliance (Free)
- **Activity Logging** - Comprehensive security event logging for audit trails
- **Security Monitoring** - Track user logins, role changes, and system modifications
- **Log Retention** - Configurable retention policies with automatic cleanup
- **IP Anonymization** - GDPR-compliant IP address anonymization
- **Security Policies** - Create and manage security policies for your organization
- **Vulnerability Scanning** (Premium) - Detect vulnerabilities in WordPress core, plugins, and themes

### 🤖 EU AI Act Compliance (Premium)
- **AI System Registry** - Register and document all AI systems used on your site
- **Risk Classification** - Categorize AI systems by risk level (minimal, limited, high, unacceptable)
- **Transparency Cards** - Auto-generate disclosure cards for Article 50 compliance
- **Human Oversight Tracking** - Document human oversight mechanisms
- **Disclosure Management** - Generate and manage AI transparency disclosures

### 🌍 Multi-Jurisdiction Support (Premium)
- **CCPA Compliance** - California Consumer Privacy Act features
- **LGPD Support** - Brazilian General Data Protection Law (coming soon)
- **Geo-Targeting** - Apply different compliance rules based on visitor location
- **Jurisdiction Rules** - Configure region-specific compliance actions

### 📊 Advanced Features (Premium)
- **Cookie Scanner** - Automatically detect and categorize cookies on your site
- **Automated DSAR Processing** - Auto-export user data from multiple sources
- **Advanced Analytics** - Detailed consent trends and compliance reports
- **Vulnerability Reports** - Export security scan results as PDF/CSV
- **Multi-Language Support** - Compatible with WPML and Polylang

## Why Unify Compliance?

### Unified Platform
Instead of juggling multiple compliance plugins, manage all your regulatory requirements from a single dashboard. Reduce plugin conflicts and maintenance overhead.

### Reduced Attack Surface
Fewer plugins means fewer vulnerabilities. Our modular architecture lets you activate only the regulations you need, keeping your site lean and secure.

### Centralized Audit Trail
All compliance activities—consents, data requests, security events, AI disclosures—are logged in one place for easy auditing and regulatory reporting.

### Future-Proof
Built for emerging regulations like the EU AI Act. As new compliance requirements emerge, Unify Compliance evolves to meet them.

## Installation

1. Download the plugin from [arwendigital.net](https://arwendigital.net/unify)
2. Upload to `/wp-content/plugins/unify-compliance/`
3. Activate the plugin in WordPress admin
4. Navigate to **Unify** in the admin menu to get started

## Getting Started

### Initial Setup
1. Go to **Unify > Dashboard** to see your compliance score
2. Follow the **Setup Checklist** to configure essential features
3. Enable modules you need under **Unify > Modules**
4. Configure each module's settings (GDPR, NIS2, etc.)

### GDPR Setup
1. Create a Privacy Policy page (or link existing one)
2. Configure the Cookie Banner under **GDPR > Cookie Banner**
3. Create a DSAR form page using `[unify_dsar_form]` shortcode
4. Monitor consent data in **GDPR > DSAR Requests**

### NIS2 Setup
1. Configure logging events under **NIS2 > Settings**
2. Set log retention period (default: 90 days)
3. Monitor activity in **NIS2 > Activity Log**
4. Create security policies under **NIS2 > Policies**

### AI Act Setup (Premium)
1. Register AI systems under **AI Act > Dashboard**
2. Set risk levels and document data processing
3. Generate transparency cards using `[unify_ai_disclosure system_id="1"]` shortcode
4. Track disclosures in **AI Act > Disclosures**

## Shortcodes

### GDPR
- `[unify_dsar_form]` - Display DSAR request form on frontend

### AI Act
- `[unify_ai_disclosure system_id="1"]` - Display AI transparency card

## Database Tables

Unify Compliance creates the following tables:
- `wp_unify_consent_logs` - Cookie consent records
- `wp_unify_dsar_requests` - Data subject access requests
- `wp_unify_cookies` - Detected cookies (Premium)
- `wp_unify_security_logs` - NIS2 activity logs
- `wp_unify_policies` - Security policies
- `wp_unify_manual_vulnerabilities` - Custom vulnerability rules
- `wp_unify_ai_systems` - Registered AI systems
- `wp_unify_ai_disclosures` - AI transparency disclosures

## Premium License

Unlock advanced features with a Premium license:
- Vulnerability scanning and reporting
- Cookie scanner and automation
- Automated DSAR processing
- Advanced analytics and reporting
- Multi-jurisdiction support
- Priority support

[Upgrade to Premium](https://arwendigital.net/wordpress-plugin/unify-compliance)

## Support

For documentation, tutorials, and support, visit:
- **Website**: [arwendigital.net](https://arwendigital.net)
- **Documentation**: [docs.arwendigital.net](https://docs.arwendigital.net)

## Compliance Frameworks

This plugin helps you comply with:
- **GDPR** - General Data Protection Regulation (EU)
- **NIS2** - Network and Information Security Directive (EU)
- **EU AI Act** - Artificial Intelligence Act (EU)
- **CCPA** - California Consumer Privacy Act (USA)
- **LGPD** - Lei Geral de Proteção de Dados (Brazil)

## License

Unify Compliance is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 2 of the License, or (at your option) any later version.

See LICENSE file for details.

## Version

Current Version: 1.0.3

---

**One Dashboard. All Regulations. Simplified Compliance.**
