jQuery(document).ready(function ($) {
    'use strict';



    // License Activation
    $('#unify-btn-activate').on('click', function (e) {
        e.preventDefault();
        const $btn = $(this);
        const $spinner = $btn.find('.unify-spinner');
        const $text = $btn.find('.unify-btn-text');
        const $message = $('#unify-license-message');
        const key = $('#unify-license-key').val().trim();

        if (!key) {
            $message.text('Please enter a license key.').show();
            return;
        }

        $btn.addClass('disabled').prop('disabled', true);
        $text.hide();
        $spinner.show();
        $message.hide();

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'unify_activate_license',
                nonce: unify_vars.license_nonce,
                license_key: key
            },
            success: function (response) {
                if (response.success) {
                    location.reload();
                } else {
                    $message.text(response.data.message || 'Activation failed.').show();
                    $btn.removeClass('disabled').prop('disabled', false);
                    $text.show();
                    $spinner.hide();
                }
            },
            error: function () {
                $message.text('Connection error. Please try again.').show();
                $btn.removeClass('disabled').prop('disabled', false);
                $text.show();
                $spinner.hide();
            }
        });
    });

    // License Deactivation
    $('#unify-btn-deactivate').on('click', function (e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to deactivate this license?')) return;

        const $btn = $(this);
        const $spinner = $btn.find('.unify-spinner');
        const $text = $btn.find('.unify-btn-text');

        $btn.addClass('disabled').prop('disabled', true);
        $text.hide();
        $spinner.show();

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'unify_deactivate_license',
                nonce: unify_vars.license_nonce
            },
            success: function (response) {
                if (response.success) {
                    // Clear local tier data
                    localStorage.removeItem('unify_tier');
                    location.reload();
                } else {
                    alert(response.data.message || 'Deactivation failed');
                    $btn.removeClass('disabled').prop('disabled', false);
                    $text.show();
                    $spinner.hide();
                }
            },
            error: function () {
                alert('Connection error. Please try again.');
                $btn.removeClass('disabled').prop('disabled', false);
                $text.show();
                $spinner.hide();
            }
        });
    });

    // Dismissable notices
    $('.notice-dismiss').on('click', function () {
        $(this).closest('.notice').remove();
    });

    // Wizard Navigation
    $('.unify-next-step').on('click', function () {
        const nextStep = $(this).data('next');
        showStep(nextStep);
    });

    $('.unify-prev-step').on('click', function () {
        const prevStep = $(this).data('prev');
        showStep(prevStep);
    });

    function showStep(step) {
        // Hide all steps
        $('.unify-wizard-step').hide();
        // Show target step
        $(`#step-${step}`).fadeIn(200);

        // Update stepper
        $('.unify-step').removeClass('active');
        $(`.unify-step[data-step="${step}"]`).addClass('active');

        // Mark previous steps as complete (visual tweak)
        for (let i = 1; i < step; i++) {
            $(`.unify-step[data-step="${i}"] .unify-step-circle`).html('✓').css('background', 'var(--unify-success)');
        }
    }

    // Seed Data interactions (Mock)
    $('.unify-btn-seed-action').on('click', function (e) {
        e.preventDefault();
        const msg = $(this).data('message') || 'Action completed successfully.';
        alert(msg);
    });

    // Generic AJAX Form Submission
    $('form.unify-ajax-form').on('submit', function (e) {
        e.preventDefault();
        const $form = $(this);
        const $btn = $form.find('button[type="submit"]');
        const originalText = $btn.text();

        $btn.text('Saving...').prop('disabled', true);

        const data = $form.serialize();

        $.post(ajaxurl, data, function (response) {
            $btn.text(originalText).prop('disabled', false);
            if (response.success) {
                // Show toast
                const toast = $('<div class="unify-toast" style="position: fixed; bottom: 20px; right: 20px; background: #10B981; color: white; padding: 12px 24px; border-radius: 4px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); z-index: 99999; transform: translateY(100px); transition: transform 0.3s;">' + response.data.message + '</div>');
                $('body').append(toast);
                setTimeout(() => toast.css('transform', 'translateY(0)'), 10);
                setTimeout(() => {
                    toast.css('transform', 'translateY(100px)');
                    setTimeout(() => toast.remove(), 300);
                }, 3000);
            } else {
                alert(response.data.message || 'Error saving settings');
            }
        });
    });

    // Live Preview Logic
    if ($('#unify-preview-banner').length) {
        // Text
        $('textarea[name="unify_banner_text"]').on('input', function () {
            $('#unify-preview-text').text($(this).val());
        });

        // Color
        $('input[name="unify_banner_primary_color"]').on('input change', function () {
            const color = $(this).val();
            $('#unify-preview-accept-btn').css('background-color', color);
            $('#unify-preview-banner').css('border-color', color);
        });

        // Position
        $('input[name="unify_banner_position"]').on('change', function () {
            const pos = $(this).val();
            const $banner = $('#unify-preview-banner');
            const color = $('input[name="unify_banner_primary_color"]').val();

            // Reset base styles
            $banner.attr('style', ''); // Clear inline styles

            // Re-apply common
            $banner.css({
                'position': 'absolute',
                'background': '#fff',
                'padding': '16px',
                'border-color': color
            });

            if (pos === 'bottom') {
                $banner.css({
                    'bottom': 0, 'left': 0, 'right': 0,
                    'border-top': '1px solid #ddd',
                    'box-shadow': '0 -2px 10px rgba(0,0,0,0.1)'
                });
            } else if (pos === 'top') {
                $banner.css({
                    'top': 0, 'left': 0, 'right': 0,
                    'border-bottom': '1px solid #ddd',
                    'box-shadow': '0 2px 10px rgba(0,0,0,0.1)'
                });
            } else if (pos === 'modal') {
                $banner.css({
                    'top': '50%', 'left': '50%',
                    'transform': 'translate(-50%, -50%)',
                    'width': '80%',
                    'border-radius': '8px',
                    'box-shadow': '0 4px 20px rgba(0,0,0,0.2)'
                });
            }
        });

        // Theme (Dark Mode)
        $('select[name="unify_banner_theme"]').on('change', function () {
            const theme = $(this).val();
            const $banner = $('#unify-preview-banner');
            const $text = $('#unify-preview-text');

            if (theme === 'dark') {
                $banner.css({
                    'background': '#1f2937',
                    'border-color': '#374151'
                });
                $text.css('color', '#f3f4f6');
            } else {
                $banner.css({
                    'background': '#fff',
                    'border-color': $('input[name="unify_banner_primary_color"]').val()
                });
                $text.css('color', '#000');
            }
        });
    }

});

// ============================================
// MODERN DASHBOARD FUNCTIONALITY
// ============================================

// Draw Sparkline Charts
function drawSparklines() {
    $('.unify-sparkline').each(function () {
        const canvas = this;
        const ctx = canvas.getContext('2d');
        const data = JSON.parse($(this).attr('data-sparkline'));

        if (!data || data.length === 0) return;

        // Set canvas size
        const width = canvas.offsetWidth;
        const height = canvas.offsetHeight;
        canvas.width = width;
        canvas.height = height;

        // Extract values
        const values = data.map(d => d.count);
        const max = Math.max(...values, 1);
        const min = Math.min(...values, 0);
        const range = max - min || 1;

        // Calculate points
        const points = values.map((value, index) => {
            const x = (index / (values.length - 1)) * width;
            const y = height - ((value - min) / range) * (height - 10) - 5;
            return { x, y };
        });

        // Draw line
        ctx.beginPath();
        ctx.strokeStyle = '#6366f1';
        ctx.lineWidth = 2;
        ctx.lineJoin = 'round';
        ctx.lineCap = 'round';

        points.forEach((point, index) => {
            if (index === 0) {
                ctx.moveTo(point.x, point.y);
            } else {
                ctx.lineTo(point.x, point.y);
            }
        });

        ctx.stroke();

        // Draw gradient fill
        ctx.lineTo(width, height);
        ctx.lineTo(0, height);
        ctx.closePath();

        const gradient = ctx.createLinearGradient(0, 0, 0, height);
        gradient.addColorStop(0, 'rgba(99, 102, 241, 0.2)');
        gradient.addColorStop(1, 'rgba(99, 102, 241, 0)');
        ctx.fillStyle = gradient;
        ctx.fill();

        // Draw points
        ctx.fillStyle = '#6366f1';
        points.forEach(point => {
            ctx.beginPath();
            ctx.arc(point.x, point.y, 3, 0, Math.PI * 2);
            ctx.fill();
        });
    });
}

// Checklist Item Toggle
$('.unify-checklist-checkbox').on('change', function () {
    const $checkbox = $(this);
    const itemId = $checkbox.data('item-id');
    const completed = $checkbox.is(':checked');

    // Update UI immediately
    $checkbox.closest('.unify-checklist-item').toggleClass('unify-checklist-completed', completed);

    // Save to backend
    $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'unify_toggle_checklist_item',
            nonce: unify_vars.dashboard_nonce,
            item_id: itemId,
            completed: completed ? 1 : 0
        },
        success: function (response) {
            if (response.success) {
                // Update progress bar
                const progress = response.data.progress;
                $('.unify-progress-fill').css('width', progress + '%');
                $('.unify-badge').text(progress + '%');
            }
        }
    });
    // Initialize dashboard animations
    if ($('.unify-dashboard-modern').length) {
        // Wait for DOM to be fully ready
        setTimeout(function () {
            drawSparklines();
        }, 100);
    }

});

// ============================================
// JURISDICTION SETTINGS
// ============================================

jQuery(document).ready(function ($) {
    // Simulation Logic
    $('.unify-simulate-btn').on('click', function (e) {
        e.preventDefault();
        const country = $(this).data('country');
        const $btn = $(this);
        const originalText = $btn.text();

        $btn.text('Setting...').prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'unify_set_simulation',
                nonce: unify_vars.nonce, // Generic admin nonce
                country: country
            },
            success: function (response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert(response.data.message || 'Error');
                    $btn.text(originalText).prop('disabled', false);
                }
            }
        });
    });
});

// exposed global functions for the inline onclick handlers
function editRule(id) {
    alert('Edit Rule Modal is coming soon! (ID: ' + id + ')');
    // Implementation of modal logic would go here
}

function deleteRule(id) {
    if (!confirm('Are you sure you want to delete this rule?')) return;

    jQuery.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'unify_delete_jurisdiction_rule',
            nonce: unify_vars.nonce,
            id: id
        },
        success: function (response) {
            if (response.success) {
                location.reload();
            } else {
                alert(response.data.message || 'Error deleting rule');
            }
        }
    });
}
