<?php
// admin/views/ai-act/dashboard.php

defined('ABSPATH') || exit;

$active_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'registry';
$systems = Unify_AI_Registry::get_all_systems();
// Assuming $stats is defined elsewhere, e.g., in the controller loading this view
// For the purpose of this edit, we'll assume it's available.
// Example placeholder for $stats if not provided:
$stats = [
    'total' => count($systems),
    'high_risk' => count(array_filter($systems, fn($s) => $s->risk_level === 'high')),
    'limited_risk' => count(array_filter($systems, fn($s) => $s->risk_level === 'limited')),
    'minimal_risk' => count(array_filter($systems, fn($s) => $s->risk_level === 'minimal')),
];
?>

<div class="wrap unify-dashboard">
    <h1><?php esc_html_e('EU AI Act Compliance', 'unify-compliance'); ?></h1>
    
    <nav class="nav-tab-wrapper">
        <a href="?page=unify-ai-act&tab=registry" class="nav-tab <?php echo esc_attr($active_tab === 'registry' ? 'nav-tab-active' : ''); ?>">
            <?php esc_html_e('AI System Registry', 'unify-compliance'); ?>
        </a>
        <a href="?page=unify-ai-act&tab=detection" class="nav-tab <?php echo esc_attr($active_tab === 'detection' ? 'nav-tab-active' : ''); ?>">
            <?php esc_html_e('Detection', 'unify-compliance'); ?>
        </a>
        <a href="?page=unify-ai-act&tab=disclosures" class="nav-tab <?php echo esc_attr($active_tab === 'disclosures' ? 'nav-tab-active' : ''); ?>">
            <?php esc_html_e('Transparency Cards', 'unify-compliance'); ?>
        </a>
    </nav>
    
    <div class="unify-tab-content">
        <?php if ($active_tab === 'registry'): ?>
            <div class="unify-card">
                <div class="unify-header-actions" style="display:flex; justify-content:space-between; align-items:center;">
                    <h3 class="unify-card-title"><?php esc_html_e( 'System Overview', 'unify-compliance' ); ?></h3>
						<div class="unify-actions">
							<a href="#" class="unify-btn unify-btn-secondary">
								<span class="dashicons dashicons-download"></span>
								<?php esc_html_e( 'Export Registry', 'unify-compliance' ); ?>
							</a>
							<button class="unify-btn unify-btn-primary" onclick="document.getElementById('add-system-modal').style.display='block'">
								<span class="dashicons dashicons-plus"></span>
								<?php esc_html_e( 'Register AI System', 'unify-compliance' ); ?>
							</button>
						</div>
					</div>
					<div class="unify-stats-grid">
						<div class="unify-stat-card">
							<div class="unify-stat-value"><?php echo esc_html( $stats['total'] ); ?></div>
							<div class="unify-stat-label"><?php esc_html_e( 'Total Systems', 'unify-compliance' ); ?></div>
						</div>
						<div class="unify-stat-card">
							<div class="unify-stat-value unify-text-error"><?php echo esc_html( $stats['high_risk'] ); ?></div>
							<div class="unify-stat-label"><?php esc_html_e( 'High Risk', 'unify-compliance' ); ?></div>
						</div>
						<div class="unify-stat-card">
							<div class="unify-stat-value unify-text-warning"><?php echo esc_html( $stats['limited_risk'] ); ?></div>
							<div class="unify-stat-label"><?php esc_html_e( 'Limited Risk', 'unify-compliance' ); ?></div>
						</div>
						<div class="unify-stat-card">
							<div class="unify-stat-value unify-text-success"><?php echo esc_html( $stats['minimal_risk'] ); ?></div>
							<div class="unify-stat-label"><?php esc_html_e( 'Minimal Risk', 'unify-compliance' ); ?></div>
						</div>
					</div>
                <p style="margin: 5px 0 20px 0; color: #646970; font-size: 14px;"><?php esc_html_e('Maintain a comprehensive record of all AI systems used on your site, classified by risk level.', 'unify-compliance'); ?></p>
                
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('System Name', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Provider', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Purpose', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Risk Level', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Created', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Actions', 'unify-compliance'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($systems)): ?>
                            <?php foreach ($systems as $system): ?>
                                <tr>
                                    <td><strong><?php echo esc_html( $system->system_name ); ?></strong></td>
									<td><span class="unify-badge unify-badge-<?php echo esc_attr( $system->risk_level ); ?>"><?php echo esc_html( ucwords( str_replace( '_', ' ', $system->risk_level ) ) ); ?></span></td>
									<td><?php echo esc_html( $system->provider ); ?></td>
									<td><?php echo esc_html( $system->purpose ); ?></td>
									<td><?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $system->created_date ) ) ); ?></td>
									<td>
										<button class="button button-small" onclick="editSystem(<?php echo esc_attr( wp_json_encode( $system ) ); ?>)"><?php esc_html_e( 'Edit', 'unify-compliance' ); ?></button>
                                        <button class="button button-small button-link-delete unify-delete-ai" data-id="<?php echo esc_attr($system->id); ?>">
                                            <?php esc_html_e('Delete', 'unify-compliance'); ?>
                                        </button>
                                        <button class="button button-small copy-shortcode" data-id="<?php echo esc_attr($system->id); ?>">
                                            <?php esc_html_e('Shortcode', 'unify-compliance'); ?>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr><td colspan="6"><?php esc_html_e('No AI systems registered yet.', 'unify-compliance'); ?></td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>



        <?php elseif ($active_tab === 'detection'): ?>
            <div class="unify-card">
                <h2><?php esc_html_e('AI Plugin Detection', 'unify-compliance'); ?></h2>
                <p style="margin: 5px 0 20px 0; color: #646970; font-size: 14px;"><?php esc_html_e('Automatically scan your website for known AI plugins and integrations to streamline your registry.', 'unify-compliance'); ?></p>
                <p>
                    <button id="unify-run-scan" class="button button-secondary"><?php esc_html_e('Scan Now', 'unify-compliance'); ?></button>
                </p>
                
                <div id="unify-scan-results">
                    <!-- Results populated via JS -->
                </div>
            </div>

        <?php elseif ($active_tab === 'disclosures'): ?>
            <div class="unify-card">
                <h2><?php esc_html_e('Transparency Cards', 'unify-compliance'); ?></h2>
                <p style="margin: 5px 0 20px 0; color: #646970; font-size: 14px;"><?php esc_html_e('Generate and manage transparency disclosures for your AI systems to be displayed on your site.', 'unify-compliance'); ?></p>
                
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('System Name', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Risk Level', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Status', 'unify-compliance'); ?></th>
                            <th><?php esc_html_e('Actions', 'unify-compliance'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($systems)): ?>
                            <?php foreach ($systems as $system): ?>
                                <tr>
                                    <td><?php echo esc_html($system->system_name); ?></td>
                                    <td>
                                        <span class="unify-badge unify-risk-<?php echo esc_attr($system->risk_level); ?>">
                                            <?php echo esc_html( ucwords(str_replace('_', ' ', $system->risk_level)) ); ?>
                                        </span>
                                    </td>
                                    <td><span class="unify-status-ready"><?php esc_html_e('Ready', 'unify-compliance'); ?></span></td>
                                    <td>
                                        <button class="button button-secondary unify-preview-card" data-id="<?php echo esc_attr($system->id); ?>">
                                            <?php esc_html_e('Preview Card', 'unify-compliance'); ?>
                                        </button>
                                        <button class="button button-small copy-shortcode" data-id="<?php echo esc_attr($system->id); ?>">
                                            <?php esc_html_e('Copy Shortcode', 'unify-compliance'); ?>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr><td colspan="4"><?php esc_html_e('No AI systems registered yet.', 'unify-compliance'); ?></td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <!-- Transparency Card Preview Modal -->
    <div id="unify-card-preview-modal" class="unify-modal" style="display:none;">
        <div class="unify-modal-content" style="width: 800px; max-width: 90%;">
            <span class="unify-close-preview" style="float:right; cursor:pointer; font-size:24px;">&times;</span>
            <h2><?php esc_html_e('Transparency Card Preview', 'unify-compliance'); ?></h2>
            <hr>
            <div id="unify-card-preview-content" style="padding: 20px; background: #f9f9f9; border: 1px solid #ddd; margin-top: 15px;">
                <p style="text-align:center;"><?php esc_html_e('Loading...', 'unify-compliance'); ?></p>
            </div>
        </div>
    </div>

    <!-- Add/Edit Modal (Global) -->
    <div id="add-system-modal" class="unify-modal" style="display:none;">
        <div class="unify-modal-content">
            <div class="unify-modal-header">
				<h3><?php esc_html_e( 'Register AI System', 'unify-compliance' ); ?></h3>
				<span class="unify-modal-close" onclick="document.getElementById('add-system-modal').style.display='none'">&times;</span>
			</div>
			<div class="unify-modal-body">
				<form method="post" action="">
					<?php wp_nonce_field( 'unify_save_ai_system', 'ai_nonce' ); ?>
					<input type="hidden" name="action" value="unify_save_ai_system">
					
					<div class="unify-form-row">
						<label><?php esc_html_e( 'System Name', 'unify-compliance' ); ?></label>
						<input type="text" name="system_name" required class="regular-text">
					</div>
					
					<div class="unify-form-row">
						<label><?php esc_html_e( 'Provider', 'unify-compliance' ); ?></label>
						<input type="text" name="provider" required class="regular-text">
					</div>
					
					<div class="unify-form-row">
						<label><?php esc_html_e( 'Purpose', 'unify-compliance' ); ?></label>
						<textarea name="purpose" required class="large-text" rows="3"></textarea>
					</div>
					
					<div class="unify-form-row">
						<label><?php esc_html_e( 'Risk Level', 'unify-compliance' ); ?></label>
						<select name="risk_level">
							<option value="minimal"><?php esc_html_e( 'Minimal Risk', 'unify-compliance' ); ?></option>
							<option value="limited"><?php esc_html_e( 'Limited Risk', 'unify-compliance' ); ?></option>
							<option value="high"><?php esc_html_e( 'High Risk', 'unify-compliance' ); ?></option>
							<option value="unacceptable"><?php esc_html_e( 'Unacceptable Risk', 'unify-compliance' ); ?></option>
						</select>
					</div>
					
					<div class="unify-form-actions">
						<button type="submit" class="unify-btn unify-btn-primary"><?php esc_html_e( 'Save System', 'unify-compliance' ); ?></button>
					</div>
				</form>
			</div>
        </div>
    </div>
</div>

<style>
/* Basic Modal Styles */
.unify-modal { position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.4); }
.unify-modal-content { background-color: #fefefe; margin: 15% auto; padding: 20px; border: 1px solid #888; width: 500px; border-radius: 5px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
.unify-close { color: #aaa; float: right; font-size: 28px; font-weight: bold; cursor: pointer; }
.unify-close:hover { color: black; }
.unify-badge { padding: 4px 8px; border-radius: 4px; color: #fff; font-size: 11px; font-weight: 600; }
.unify-risk-minimal { background-color: #2271b1; }
.unify-risk-limited { background-color: #f0b849; color: #333; }
.unify-risk-high { background-color: #d63638; }
.unify-risk-unacceptable { background-color: #000; border: 1px solid #d63638; color: #ffcccc; box-shadow: 0 0 5px rgba(214, 54, 56, 0.5); }
.unify-status-ready { color: #00a32a; font-weight: 500; }
.unify-form-group { margin-bottom: 15px; }

/* Transparency Card Preview Styles */
.unify-transparency-card {
    background: #fff;
    border: 1px solid #e0e0e0;
    border-radius: 8px;
    padding: 25px; /* Fix edge issue */
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    font-family: inherit;
    color: #3c434a;
    max-width: 100%;
    margin: 0 auto;
    position: relative;
    overflow: hidden;
}

.unify-transparency-card h3 {
    margin-top: 0;
    font-size: 1.5em;
    padding-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
    margin-bottom: 20px;
    color: #1d2327;
}

.unify-transparency-card .unify-ai-detail {
    margin-bottom: 12px;
    font-size: 1.1em;
    line-height: 1.5;
}

.unify-transparency-card .unify-label {
    font-weight: 700;
    color: #646970;
    margin-right: 8px;
}

.unify-transparency-card .unify-badge {
    display: inline-block;
    vertical-align: middle;
}

.unify-transparency-card .unify-ai-section {
    margin-top: 25px;
    background: #f8f9fa;
    padding: 20px;
    border-radius: 6px;
    border: 1px solid #f0f0f0;
}

.unify-transparency-card h4 {
    margin: 0 0 10px 0;
    font-size: 0.9em;
    text-transform: uppercase;
    color: #646970;
    letter-spacing: 0.5px;
}

.unify-transparency-card p {
    margin: 0;
    font-size: 1em;
    line-height: 1.6;
}

.unify-transparency-card .unify-ai-footer {
    margin-top: 25px;
    padding-top: 15px;
    border-top: 1px solid #f0f0f0;
    font-weight: 600;
    color: #2271b1;
    display: flex;
    align-items: center;
}

.unify-icon-check {
    margin-right: 8px;
    font-size: 1.2em;
}

/* Override background colors from generic badges and provide border branding */
.unify-transparency-card.unify-risk-minimal { border-left: 5px solid #2271b1; background: #fff; }
.unify-transparency-card.unify-risk-limited { border-left: 5px solid #f0b849; background: #fff; }
.unify-transparency-card.unify-risk-high { border-left: 5px solid #d63638; background: #fff; }
.unify-transparency-card.unify-risk-unacceptable { border-left: 5px solid #d63638; background: #fff; border-right: 1px solid #e0e0e0; border-top: 1px solid #e0e0e0; border-bottom: 1px solid #e0e0e0; }

/* Fix text contrast in case generic rules bleed in */
.unify-transparency-card.unify-risk-limited, 
.unify-transparency-card.unify-risk-unacceptable { color: #3c434a; }
</style>

<script>
jQuery(document).ready(function($) {
    // Modal handling
    $('#unify-add-ai-system').on('click', function() {
        $('#unify-ai-form')[0].reset();
        $('#ai-id').val('');
        $('#unify-modal-title').text('<?php echo esc_js( esc_html__('Register AI System', 'unify-compliance') ); ?>');
        $('#unify-ai-modal').fadeIn();
    });
    
    $('.unify-close').on('click', function() {
        $('#unify-ai-modal').fadeOut();
    });

    // Form Submission
    $('#unify-ai-form').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.post(ajaxurl, formData, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data || '<?php echo esc_js( esc_html__('Unknown error', 'unify-compliance') ); ?>'));
            }
        });
    });

    // Delete
    $('.unify-delete-ai').on('click', function() {
        if (!confirm('<?php echo esc_js( esc_html__('Are you sure you want to delete this system?', 'unify-compliance') ); ?>')) return;
        
        var id = $(this).data('id');
        $.post(ajaxurl, {
            action: 'unify_delete_ai_system',
            nonce: '<?php echo esc_js( wp_create_nonce('unify_delete_ai_system') ); ?>',
            id: id
        }, function(response) {
            if (response.success) location.reload();
        });
    });

    // Edit - load system data into modal
    $('.unify-edit-ai').on('click', function() {
        var id = $(this).data('id');
        
        $.post(ajaxurl, {
            action: 'unify_get_ai_system',
            nonce: '<?php echo esc_js( wp_create_nonce('unify_get_ai_system') ); ?>',
            id: id
        }, function(response) {
            if (response.success && response.data) {
                var system = response.data;
                $('#ai-id').val(system.id);
                $('input[name="system_name"]').val(system.system_name);
                $('input[name="provider"]').val(system.provider);
                $('select[name="risk_level"]').val(system.risk_level);
                $('textarea[name="purpose"]').val(system.purpose);
                $('input[name="human_oversight"]').prop('checked', system.human_oversight == 1);
                $('#unify-modal-title').text('<?php echo esc_js( esc_html__('Edit AI System', 'unify-compliance') ); ?>');
                $('#unify-ai-modal').fadeIn();
            } else {
                alert('<?php echo esc_js( esc_html__('Error loading system data', 'unify-compliance') ); ?>');
            }
        });
    });

    // Copy Shortcode to clipboard
    $('.copy-shortcode').on('click', function() {
        var id = $(this).data('id');
        var shortcode = '[unify_ai_disclosure system_id="' + id + '"]';
        
        // Use modern clipboard API if available, fallback to execCommand
        if (navigator.clipboard && navigator.clipboard.writeText) {
            navigator.clipboard.writeText(shortcode).then(function() {
                alert('Shortcode copied: ' + shortcode);
            }).catch(function() {
                prompt('Copy this shortcode:', shortcode);
            });
        } else {
            prompt('Copy this shortcode:', shortcode);
        }
    });
    
    // Scan
    $('#unify-run-scan').on('click', function() {
        var $btn = $(this);
        $btn.prop('disabled', true).text('Scanning...');
        
        $.post(ajaxurl, {
            action: 'unify_run_ai_scan',
            nonce: '<?php echo esc_js( wp_create_nonce('unify_run_ai_scan') ); ?>' // Need to ensure this nonce is created on PHP side
        }, function(response) {
            $btn.prop('disabled', false).text('Scan Now');
            if (response.success) {
                var html = '<ul style="margin-top:20px;">';
                if (response.data.length === 0) {
                    html += '<li>No AI plugins detected.</li>';
                } else {
                    response.data.forEach(function(item) {
                        html += '<li><strong>' + item.name + '</strong> (' + item.known_as + ') - <a href="#" class="unify-register-suggestion" data-name="' + item.name + '" data-provider="Plugin">Register</a></li>';
                    });
                }
                html += '</ul>';
                $('#unify-scan-results').html(html);
            }
        });
    });

    // Register Suggestion (Scan Results)
    $(document).on('click', '.unify-register-suggestion', function(e) {
        e.preventDefault();
        var name = $(this).data('name');
        
        // Switch to registry tab logic would be complex with page reload, 
        // but since modal is on page, we can just open it if we are on registry tab?
        // Wait, scan is on 'detection' tab. Modal HTML is on 'registry' tab (if block).
        // Issue: Modal HTML is inside `if ($active_tab === 'registry')`.
        // Fix: Move Modal HTML outside the if block so it's available on all tabs.
        
        // Assuming I'll fix the modal visibility in a separate edit or user instruction if needed,
        // but for now I will rely on moving the modal out or just instructing user to go to registry.
        // ACTUALLY, I should move the modal HTML out of the PHP if block in this same multi_replace?
        // No, I can't target it easily with this Chunk. 
        // I will implement a redirect-with-hash approach or just alert for now?
        // Better: I will move the modal HTML in a subsequent edit or ensure it is available.
        // Let's check the file content again. Modal is at line 78 inside 'registry' block.
        // It needs to be moved out. 
        // For now, I will implement the JS and then move the modal HTML in a separate call to be safe.
        
        // HOWEVER, the "Register" button is on the "Detection" tab.
        // If the Modal is only on "Registry" tab, this click won't work.
        // I must move the modal HTML.
        
        // Alternative: Just alert user to go to registry tab. (Bad UX)
        // Correct fix: Move modal HTML out of keys.
        
        // Updating JS to handle it assuming modal is present:
        $('#unify-ai-form')[0].reset();
        $('#ai-id').val('');
        $('input[name="system_name"]').val(name);
        $('input[name="provider"]').val('External Plugin'); // or 'Plugin'
        $('select[name="risk_level"]').val('limited'); // Safety default
        
        $('#unify-modal-title').text('<?php echo esc_js( __('Register AI System', 'unify-compliance') ); ?>');
        $('#unify-ai-modal').fadeIn();
    });

    // Preview Card
    $('.unify-preview-card').on('click', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        $('#unify-card-preview-modal').fadeIn();
        $('#unify-card-preview-content').html('<p style="text-align:center;">Loading...</p>');
        
        $.post(ajaxurl, {
            action: 'unify_preview_transparency_card',
            nonce: '<?php echo esc_js( wp_create_nonce('unify_preview_transparency_card') ); ?>',
            id: id
        }, function(response) {
            if (response.success) {
                $('#unify-card-preview-content').html(response.data);
            } else {
                $('#unify-card-preview-content').html('<p>Error loading preview.</p>');
            }
        });
    });

    $('.unify-close-preview').on('click', function() {
        $('#unify-card-preview-modal').fadeOut();
    });
});
</script>
