<?php
/**
 * Modern Dashboard View
 *
 * @package Unify_Compliance
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get dashboard data
$compliance_score = Unify_Dashboard_Data::get_compliance_score();
$gdpr_status      = Unify_Dashboard_Data::get_gdpr_status();
$nis2_status      = Unify_Dashboard_Data::get_nis2_status();
$quick_stats      = Unify_Dashboard_Data::get_quick_stats();
$recent_activity  = Unify_Dashboard_Data::get_recent_activity( 5 );
$checklist_items  = Unify_Dashboard_Data::get_checklist_items();
$checklist_progress = Unify_Dashboard_Data::get_checklist_progress();
$is_premium       = unify_is_premium();
?>

<div class="unify-dashboard-modern">

	<!-- Header Section -->
	<!-- <div class="unify-dashboard-header">
		
		<?php if ( ! $is_premium ) : ?>
			<a href="#" class="unify-btn unify-btn-premium">
				<span class="dashicons dashicons-star-filled"></span>
				Upgrade to Premium
			</a>
		<?php else : ?>
			<span class="unify-badge unify-badge-premium">
				<span class="dashicons dashicons-yes"></span>
				Premium Active
			</span>
		<?php endif; ?>
	</div> -->

	<!-- Value Proposition Section -->
	<div class="unify-value-prop">
		<div class="unify-value-prop-content">
			<h2>One Dashboard. All Regulations.</h2>
			<p>Unify Compliance replaces fragmented compliance tools with a single, unified platform. <span class="unify-highlight-text">Manage GDPR, NIS2, EU AI Act, and more</span> from one dashboard—reducing security vulnerabilities, eliminating plugin conflicts, and streamlining your audit trail.</p>
		</div>
		<div class="unify-value-prop-features">
			<div class="unify-value-feature">
				<span class="dashicons dashicons-shield-alt"></span>
				<div>
					<strong>Unified Audit Trail</strong>
					<p>One centralized log for all compliance activities across frameworks</p>
				</div>
			</div>
			<div class="unify-value-feature">
				<span class="dashicons dashicons-performance"></span>
				<div>
					<strong>Reduced Attack Surface</strong>
					<p>Fewer plugins means fewer vulnerabilities and faster site performance</p>
				</div>
			</div>
			<div class="unify-value-feature">
				<span class="dashicons dashicons-admin-tools"></span>
				<div>
					<strong>Modular Architecture</strong>
					<p>Activate only the regulations you need—no bloat, no clutter</p>
				</div>
			</div>
			<div class="unify-value-feature">
				<span class="dashicons dashicons-chart-line"></span>
				<div>
					<strong>Future-Proof</strong>
					<p>Built for emerging regulations like the EU AI Act and beyond</p>
				</div>
			</div>
		</div>
	</div>

	<!-- Hero: Compliance Score Gauge -->
	<div class="unify-card unify-card-hero">
		<div class="unify-compliance-gauge">
			<div class="unify-gauge-container">
				<?php
				// Calculate gauge circumference and offset server-side
				// Radius is 80, so semi-circle arc length is π * 80 ≈ 251.327
				$circumference = 251.327;
				$offset = $circumference - ( $compliance_score / 100 ) * $circumference;
				?>
				<svg class="unify-gauge-svg" viewBox="0 0 200 120">
					<!-- Background arc -->
					<path class="unify-gauge-bg" d="M 20 100 A 80 80 0 0 1 180 100" fill="none" stroke="#e5e7eb" stroke-width="12" stroke-linecap="round"/>
					<!-- Progress arc -->
					<path class="unify-gauge-progress" d="M 20 100 A 80 80 0 0 1 180 100" fill="none" stroke="url(#gaugeGradient)" stroke-width="12" stroke-linecap="round" stroke-dasharray="<?php echo esc_attr( $circumference ); ?>" stroke-dashoffset="<?php echo esc_attr( $offset ); ?>" style="transition: stroke-dashoffset 1s ease-out;"/>
					<defs>
						<linearGradient id="gaugeGradient" x1="0%" y1="0%" x2="100%" y2="0%">
							<stop offset="0%" style="stop-color:#6366f1;stop-opacity:1" />
							<stop offset="100%" style="stop-color:#8b5cf6;stop-opacity:1" />
						</linearGradient>
					</defs>
				</svg>
				<div class="unify-gauge-value">
					<span class="unify-gauge-number"><?php echo esc_html( $compliance_score ); ?></span>
					<span class="unify-gauge-label">Compliance Score</span>
				</div>
			</div>
			<div class="unify-gauge-info">
				<h3>Overall Compliance Status</h3>
				<p>Your compliance score is calculated based on active modules, configured features, and pending actions.</p>
				
				<?php
				// Debug info removed for production
				?>
				
				<div class="unify-gauge-breakdown">
					<div class="unify-gauge-item">
						<span class="dashicons dashicons-<?php echo ( $gdpr_active && $banner_enabled ) ? 'yes' : 'no'; ?>"></span>
						Cookie Banner
					</div>
					<div class="unify-gauge-item">
						<span class="dashicons dashicons-<?php echo $privacy_exists ? 'yes' : 'no'; ?>"></span>
						Privacy Policy
					</div>
					<div class="unify-gauge-item">
						<span class="dashicons dashicons-<?php echo $dsar_page ? 'yes' : 'no'; ?>"></span>
						DSAR Form
					</div>
					<div class="unify-gauge-item">
						<span class="dashicons dashicons-<?php echo $nis2_active ? 'yes' : 'no'; ?>"></span>
						Activity Logging
					</div>
				</div>
				
			</div>
		</div>
	</div>

	<!-- Quick Stats Row -->
	<div class="unify-stats-grid">
		<?php foreach ( $quick_stats as $stat ) : ?>
			<div class="unify-stat-card">
				<div class="unify-stat-icon" style="background: <?php echo esc_attr( $stat['color'] ); ?>20; color: <?php echo esc_attr( $stat['color'] ); ?>;">
					<span class="dashicons dashicons-<?php echo esc_attr( $stat['icon'] ); ?>"></span>
				</div>
				<div class="unify-stat-content">
					<div class="unify-stat-value"><?php echo esc_html( $stat['value'] ); ?></div>
					<div class="unify-stat-label"><?php echo esc_html( $stat['label'] ); ?></div>
					<div class="unify-stat-subtitle"><?php echo esc_html( $stat['subtitle'] ); ?></div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>

	<!-- Module Cards Grid -->
	<div class="unify-modules-grid">
		
		<!-- GDPR Module Card -->
		<?php if ( Unify_Module_Manager::is_module_active( 'gdpr' ) ) : ?>
		<div class="unify-card unify-module-card">
			<div class="unify-card-header">
				<div>
					<h3 class="unify-card-title">
						<span class="dashicons dashicons-shield-alt"></span>
						GDPR Compliance
					</h3>
					<p class="unify-card-subtitle">Cookie consent & data rights</p>
					<?php if ( unify_is_premium() ) : ?>
					<div class="unify-badge unify-badge-premium" style="display: inline-flex; align-items: center; gap: 4px; padding: 2px 6px; font-size: 10px; margin-top: 4px;">
						<span class="dashicons dashicons-universal-access" style="font-size: 12px; height: 12px; width: 12px;"></span>
						WCAG 2.2 AA
					</div>
					<?php endif; ?>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=unify-gdpr' ) ); ?>" class="unify-btn unify-btn-secondary unify-btn-sm">
					Settings
				</a>
			</div>
			<div class="unify-module-stats">
				<div class="unify-module-stat">
					<div class="unify-module-stat-value"><?php echo esc_html( $gdpr_status['total_consents'] ); ?></div>
					<div class="unify-module-stat-label">Total Consents</div>
				</div>
				<div class="unify-module-stat">
					<div class="unify-module-stat-value"><?php echo esc_html( $gdpr_status['acceptance_rate'] ); ?>%</div>
					<div class="unify-module-stat-label">Acceptance Rate</div>
				</div>
				<div class="unify-module-stat">
					<div class="unify-module-stat-value <?php echo $gdpr_status['pending_dsar'] > 0 ? 'unify-stat-warning' : ''; ?>">
						<?php echo esc_html( $gdpr_status['pending_dsar'] ); ?>
					</div>
					<div class="unify-module-stat-label">Pending DSAR</div>
				</div>
			</div>
			<?php if ( ! empty( $gdpr_status['consent_sparkline'] ) ) : ?>
			<div class="unify-sparkline-container">
				<canvas class="unify-sparkline" data-sparkline='<?php echo esc_attr( wp_json_encode( $gdpr_status['consent_sparkline'] ) ); ?>'></canvas>
				<div class="unify-sparkline-label">Consent trend (7 days)</div>
			</div>
			<?php endif; ?>
			<div class="unify-status-list">
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $gdpr_status['banner_enabled'] ? 'yes' : 'warning'; ?>" style="color: <?php echo $gdpr_status['banner_enabled'] ? '#10b981' : '#f59e0b'; ?>;"></span>
					Cookie Banner <?php echo $gdpr_status['banner_enabled'] ? 'Active' : 'Disabled'; ?>
				</div>
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $gdpr_status['privacy_exists'] ? 'yes' : 'warning'; ?>" style="color: <?php echo $gdpr_status['privacy_exists'] ? '#10b981' : '#f59e0b'; ?>;"></span>
					Privacy Policy <?php echo $gdpr_status['privacy_exists'] ? 'Exists' : 'Missing'; ?>
				</div>
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $gdpr_status['dsar_configured'] ? 'yes' : 'warning'; ?>" style="color: <?php echo $gdpr_status['dsar_configured'] ? '#10b981' : '#f59e0b'; ?>;"></span>
					DSAR Form <?php echo $gdpr_status['dsar_configured'] ? 'Configured' : 'Not Set'; ?>
				</div>
			</div>
		</div>
		<?php endif; ?>

		<!-- NIS2 Module Card -->
		<?php if ( Unify_Module_Manager::is_module_active( 'nis2' ) ) : ?>
		<div class="unify-card unify-module-card">
			<div class="unify-card-header">
				<div>
					<h3 class="unify-card-title">
						<span class="dashicons dashicons-lock"></span>
						NIS2 Compliance
					</h3>
					<p class="unify-card-subtitle">Security logging & monitoring</p>
				</div>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=unify-nis2' ) ); ?>" class="unify-btn unify-btn-secondary unify-btn-sm">
					Settings
				</a>
			</div>
			<div class="unify-module-stats">
				<div class="unify-module-stat">
					<div class="unify-module-stat-value unify-stat-<?php echo $nis2_status['security_score'] >= 80 ? 'success' : ( $nis2_status['security_score'] >= 50 ? 'warning' : 'error' ); ?>">
						<?php echo esc_html( $nis2_status['security_score'] ); ?>
					</div>
					<div class="unify-module-stat-label">Security Score</div>
				</div>
				<div class="unify-module-stat">
					<div class="unify-module-stat-value"><?php echo esc_html( $nis2_status['successful_logins'] ); ?></div>
					<div class="unify-module-stat-label">Successful Logins</div>
				</div>
				<div class="unify-module-stat">
					<div class="unify-module-stat-value <?php echo $nis2_status['failed_logins'] > 10 ? 'unify-stat-error' : ''; ?>">
						<?php echo esc_html( $nis2_status['failed_logins'] ); ?>
					</div>
					<div class="unify-module-stat-label">Failed Logins</div>
				</div>
			</div>
			<?php if ( ! empty( $nis2_status['failed_login_sparkline'] ) ) : ?>
			<div class="unify-sparkline-container">
				<canvas class="unify-sparkline" data-sparkline='<?php echo esc_attr( wp_json_encode( $nis2_status['failed_login_sparkline'] ) ); ?>'></canvas>
				<div class="unify-sparkline-label">Failed login trend (7 days)</div>
			</div>
			<?php endif; ?>
			<div class="unify-status-list">
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $nis2_status['logging_enabled'] ? 'yes' : 'warning'; ?>" style="color: <?php echo $nis2_status['logging_enabled'] ? '#10b981' : '#f59e0b'; ?>;"></span>
					Activity Logging <?php echo $nis2_status['logging_enabled'] ? 'Active' : 'Disabled'; ?>
				</div>
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $nis2_status['retention_configured'] ? 'yes' : 'warning'; ?>" style="color: <?php echo $nis2_status['retention_configured'] ? '#10b981' : '#f59e0b'; ?>;"></span>
					Log Retention <?php echo $nis2_status['retention_configured'] ? esc_html($nis2_status['retention_days']) . ' days' : 'Not Configured'; ?>
				</div>
				<div class="unify-status-item">
					<span class="dashicons dashicons-<?php echo $nis2_status['suspicious_ips'] === 0 ? 'yes' : 'warning'; ?>" style="color: <?php echo $nis2_status['suspicious_ips'] === 0 ? '#10b981' : '#f59e0b'; ?>;"></span>
					<?php echo esc_html( $nis2_status['suspicious_ips'] ); ?> Suspicious IPs
				</div>
			</div>
		</div>
		<?php endif; ?>

	</div>

	<!-- Activity Stream & Checklist Row -->
	<div class="unify-bottom-grid">
		
		<!-- Recent Activity Stream -->
		<div class="unify-card unify-activity-card">
			<div class="unify-card-header">
				<h3 class="unify-card-title">
					<span class="dashicons dashicons-clock"></span>
					Recent Activity
				</h3>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=unify-nis2&tab=activity-log' ) ); ?>" class="unify-btn unify-btn-secondary unify-btn-sm">
					View All
				</a>
			</div>
			<div class="unify-activity-stream">
				<?php if ( ! empty( $recent_activity ) ) : ?>
					<?php foreach ( $recent_activity as $activity ) : ?>
						<div class="unify-activity-item unify-activity-<?php echo esc_attr( $activity['severity'] ); ?>">
							<div class="unify-activity-icon">
								<span class="dashicons dashicons-<?php 
									echo $activity['severity'] === 'critical' ? 'warning' : 
										( $activity['severity'] === 'warning' ? 'info' : 'yes' ); 
								?>"></span>
							</div>
							<div class="unify-activity-content">
								<div class="unify-activity-event"><?php echo esc_html( $activity['event'] ); ?></div>
								<div class="unify-activity-details"><?php echo esc_html( $activity['details'] ); ?></div>
								<div class="unify-activity-meta">
									<span><?php echo esc_html( $activity['user'] ); ?></span>
									<span>•</span>
									<span><?php echo esc_html( $activity['time'] ); ?></span>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				<?php else : ?>
					<div class="unify-empty-state">
						<span class="dashicons dashicons-info"></span>
						<p>No recent activity to display</p>
					</div>
				<?php endif; ?>
			</div>
		</div>

		<!-- Checklist Widget -->
		<div class="unify-card unify-checklist-card">
			<div class="unify-card-header">
				<h3 class="unify-card-title">
					<span class="dashicons dashicons-clipboard"></span>
					Setup Checklist
				</h3>
				<span class="unify-badge unify-badge-<?php echo $checklist_progress >= 100 ? 'success' : 'warning'; ?>">
					<?php echo esc_html( $checklist_progress ); ?>%
				</span>
			</div>
			<div class="unify-checklist-progress">
				<div class="unify-progress-bar">
					<div class="unify-progress-fill" style="width: <?php echo esc_attr( $checklist_progress ); ?>%;"></div>
				</div>
			</div>
			<div class="unify-checklist-items">
				<?php if ( ! empty( $checklist_items ) ) : ?>
					<?php foreach ( $checklist_items as $item ) : ?>
						<div class="unify-checklist-item <?php echo $item['completed'] ? 'unify-checklist-completed' : ''; ?>">
							<input 
								type="checkbox" 
								<?php checked( $item['completed'] ); ?>
								data-item-id="<?php echo esc_attr( $item['id'] ); ?>"
								class="unify-checklist-checkbox"
							>
							<span class="unify-checklist-label"><?php echo esc_html( $item['label'] ); ?></span>
							<a href="<?php echo esc_url( $item['link'] ); ?>" class="unify-checklist-link">
								<span class="dashicons dashicons-arrow-right-alt"></span>
							</a>
						</div>
					<?php endforeach; ?>
				<?php else : ?>
					<div class="unify-empty-state">
						<span class="dashicons dashicons-yes"></span>
						<p>All setup tasks completed!</p>
					</div>
				<?php endif; ?>
			</div>
		</div>

	</div>

	<!-- Premium Features Preview (Free Users Only) -->
	<?php if ( ! $is_premium ) : ?>
	<div class="unify-card unify-premium-preview">
		<div class="unify-premium-overlay">
			<span class="dashicons dashicons-lock"></span>
			<h3>Premium Features</h3>
			<p>Unlock advanced reporting, automated DSAR processing, and AI Act compliance tools.</p>
			<a href="#" class="unify-btn unify-btn-premium">Upgrade Now</a>
		</div>
		<div class="unify-premium-content">
			<h3>Advanced Compliance Tools</h3>
			<div class="unify-premium-features">
				<div class="unify-premium-feature">
					<span class="dashicons dashicons-chart-bar"></span>
					<strong>Advanced Analytics</strong>
					<p>Detailed consent trends and compliance reports</p>
				</div>
				<div class="unify-premium-feature">
					<span class="dashicons dashicons-admin-tools"></span>
					<strong>Auto DSAR Processing</strong>
					<p>Automatically export and process data requests</p>
				</div>
				<div class="unify-premium-feature">
					<span class="dashicons dashicons-admin-site-alt3"></span>
					<strong>Multi-Jurisdiction</strong>
					<p>Geo-targeted compliance rules per region</p>
				</div>
			</div>
		</div>
	</div>
	<?php endif; ?>

</div>
