<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/gdpr/cookie-banner.php
$banner_text = Unify_Settings::get_option('unify_banner_text');
$position = Unify_Settings::get_option('unify_banner_position');
$primary_color = Unify_Settings::get_option('unify_banner_primary_color');
$privacy_id = Unify_Settings::get_option('unify_privacy_page_id');
?>
<div class="unify-tabs">
    <a href="?page=unify-gdpr&tab=banner" class="unify-tab active">Cookie Banner</a>
    <a href="?page=unify-gdpr&tab=queue" class="unify-tab">DSAR Requests</a>
    <a href="?page=unify-gdpr&tab=form" class="unify-tab">DSAR Form</a>
    <a href="?page=unify-gdpr&tab=scanner" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> Cookie Scanner</a>
    <a href="?page=unify-gdpr&tab=automation" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> DSAR Automation</a>
</div>

<div class="unify-grid" style="grid-template-columns: 2fr 1fr;">
    
    <!-- Settings Column -->
    <form class="unify-card unify-ajax-form">
        <input type="hidden" name="action" value="unify_save_banner_settings">
        <?php wp_nonce_field('unify_admin_nonce', 'nonce'); ?>
        
        <div class="unify-card-header">
            <h3 class="unify-card-title">Banner Configuration</h3>
            <button type="submit" class="unify-btn unify-btn-primary">Save Settings</button>
        </div>
        <p style="color: var(--unify-text-secondary); margin: 0 0 20px 0; font-size: 14px;">
            Customize the appearance and behavior of your cookie consent banner to comply with GDPR & CCPA.
            <?php if (unify_is_premium()) : ?>
            <span class="unify-badge unify-badge-success" style="vertical-align: middle; margin-left: 8px;">
                <span class="dashicons dashicons-universal-access" style="font-size: 12px; vertical-align: middle;"></span>
                WCAG 2.2 AA Compliant
            </span>
            <?php endif; ?>
        </p>

        <div style="margin-bottom: 20px;">
            <label style="display: block; font-weight: 600; margin-bottom: 8px;">Banner Text</label>
            <textarea name="unify_banner_text" style="width: 100%; height: 80px; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;"><?php echo esc_textarea(wp_unslash($banner_text)); ?></textarea>
        </div>

        <div class="unify-grid" style="grid-template-columns: 1fr 1fr; gap: 16px; margin-bottom: 20px;">
            <div>
                 <label style="display: block; font-weight: 600; margin-bottom: 8px;">Primary Color</label>
                 <input type="color" name="unify_banner_primary_color" value="<?php echo esc_attr($primary_color); ?>" style="width: 100%; height: 40px;">
            </div>
             <div>
                 <label style="display: block; font-weight: 600; margin-bottom: 8px;">Theme</label>
                 <select name="unify_banner_theme" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
                     <option value="3" <?php selected(esc_attr($privacy_id), 3); ?>>Privacy Policy (Auto-detected)</option>
            <option value="0" <?php selected(esc_attr($privacy_id), 0); ?>>create new...</option>
                 </select>
            </div>
        </div>

        <div style="margin-bottom: 20px;">
             <label style="display: block; font-weight: 600; margin-bottom: 8px;">Position</label>
             <div style="display: flex; gap: 16px;">
                 <label><input type="radio" name="unify_banner_position" value="bottom" <?php checked($position, 'bottom'); ?>> Bottom Bar</label>
                 <label><input type="radio" name="unify_banner_position" value="top" <?php checked($position, 'top'); ?>> Top Bar</label>
                 <label><input type="radio" name="unify_banner_position" value="modal" <?php checked($position, 'modal'); ?>> Center Modal</label>
             </div>
        </div>

        <div style="margin-bottom: 20px;">
             <label style="display: block; font-weight: 600; margin-bottom: 8px;">Privacy Policy Page</label>
             <?php wp_dropdown_pages([
                 'name' => 'unify_privacy_page_id',
                 'selected' => esc_attr($privacy_id),
                 'show_option_none' => '-- Select Page --',
                 'class' => 'unify-select',
                 'style' => 'width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;' // Inline style fallback
             ]); ?>
             <?php if($privacy_id): ?>
             <p style="font-size: 12px; color: var(--unify-success); margin-top: 4px;">✓ Page detected/selected</p>
             <?php endif; ?>
        </div>

        <div style="margin-bottom: 20px; border-top: 1px solid var(--unify-border); padding-top: 20px;">
            <h4 style="margin-top: 0;">Cookie Categories</h4>
            <div class="unify-status-item">
                <input type="checkbox" checked disabled> <strong>Necessary</strong> (Always on)
            </div>
            <div class="unify-status-item">
                <input type="checkbox" checked> <strong>Functional</strong> (User preferences)
            </div>
            <div class="unify-status-item">
                <input type="checkbox" checked> <strong>Analytics</strong> (Traffic stats)
            </div>
            <div class="unify-status-item">
                <input type="checkbox" checked> <strong>Marketing</strong> (Ad targeting)
            </div>
        </div>

        <div class="unify-card" style="background: #F3F4F6; margin-bottom: 20px; border: none; padding: 12px;">
            <div style="display: flex; gap: 10px;">
                <span class="dashicons dashicons-translation" style="color: var(--unify-text-secondary);"></span>
                <div>
                    <strong style="font-size: 13px;">Multi-Language Support</strong>
                    <p style="font-size: 12px; margin: 4px 0 0 0; color: var(--unify-text-secondary);">
                        Fully compatible with WPML and Polylang. Strings can be translated in your plugin string tables.
                    </p>
                </div>
            </div>
        </div>
        
        <div style="border-top: 1px solid var(--unify-border); padding-top: 20px;">
             <h4 style="margin-top: 0;">
                 <span class="dashicons dashicons-shield" style="color: var(--unify-primary-color);"></span>
                 Script Blocking (Prior Consent)
             </h4>
             <p style="font-size: 13px; color: var(--unify-text-secondary); margin-bottom: 16px;">
                 GDPR requires blocking non-essential scripts <strong>before</strong> consent is given. When enabled, tracking scripts are blocked by default and only load after the user accepts cookies.
             </p>
             
             <div class="unify-status-item" style="margin-bottom: 12px;">
                 <?php $blocking_enabled = get_option('unify_script_blocking_enabled', true); ?>
                 <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                     <input type="checkbox" name="unify_script_blocking_enabled" value="1" <?php checked($blocking_enabled, true); ?>>
                     <strong>Enable Script Blocking</strong>
                 </label>
                 <p style="font-size: 12px; color: var(--unify-text-secondary); margin: 4px 0 0 24px;">
                     When enabled, analytics and marketing scripts are blocked until consent is given.
                 </p>
             </div>
             
             <div style="background: #f9fafb; padding: 12px; border-radius: 6px; margin-bottom: 16px;">
                 <strong style="font-size: 13px; display: block; margin-bottom: 8px;">
                     <span class="dashicons dashicons-visibility" style="font-size: 14px;"></span>
                     Auto-Detected & Blocked Scripts
                 </strong>
                 <div style="display: flex; flex-wrap: wrap; gap: 6px; margin-bottom: 8px;">
                     <span class="unify-badge unify-badge-warning" style="font-size: 10px;">Google Analytics</span>
                     <span class="unify-badge unify-badge-warning" style="font-size: 10px;">Google Tag Manager</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 10px;">Facebook Pixel</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 10px;">Meta Pixel</span>
                     <span class="unify-badge unify-badge-warning" style="font-size: 10px;">Hotjar</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 10px;">LinkedIn Insights</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 10px;">TikTok Pixel</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 10px;">Twitter Ads</span>
                     <span class="unify-badge unify-badge-default" style="font-size: 10px;">+20 more</span>
                 </div>
                 <p style="font-size: 11px; color: var(--unify-text-secondary); margin: 0;">
                     <span class="unify-badge unify-badge-warning" style="font-size: 9px; padding: 2px 6px;">Analytics</span>
                     <span class="unify-badge unify-badge-error" style="font-size: 9px; padding: 2px 6px;">Marketing</span>
                     categories are blocked until user consents.
                 </p>
             </div>
             
             <div class="unify-status-item" style="margin-bottom: 12px;">
                 <?php $ccpa_enabled = get_option('unify_ccpa_dnsmi_enabled', false); ?>
                 <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                     <input type="checkbox" name="unify_ccpa_dnsmi_enabled" value="1" <?php checked($ccpa_enabled, true); ?>>
                     <strong>Enable "Do Not Sell My Info" link (CCPA)</strong>
                 </label>
             </div>
        </div>

        <!-- WCAG 2.2 Accessibility Section (Premium Feature) -->
        <div style="border-top: 1px solid var(--unify-border); padding-top: 20px; margin-top: 20px;">
            <h4 style="margin-top: 0; display: flex; align-items: center; gap: 8px;">
                <span class="dashicons dashicons-universal-access" style="color: var(--unify-primary-color);"></span>
                Accessibility (WCAG 2.2)
                <span class="unify-badge unify-badge-premium">Premium</span>
            </h4>
            
            <?php if (unify_is_premium()) : ?>
                <?php $wcag_enabled = get_option('unify_wcag_mode_enabled', true); ?>
                
                <!-- WCAG Badge -->
                <div style="background: #0066cc; color: white; padding: 12px 16px; border-radius: 6px; margin-bottom: 16px; display: flex; align-items: center; gap: 12px;">
                    <span class="dashicons dashicons-universal-access" style="font-size: 24px;"></span>
                    <div>
                        <strong style="display: block; font-size: 14px;">WCAG 2.2 Level AA Compliant</strong>
                        <span style="font-size: 12px; opacity: 0.9;">Your banner meets international accessibility standards</span>
                    </div>
                </div>
                
                <!-- Enable/Disable Toggle -->
                <div class="unify-status-item" style="margin-bottom: 16px;">
                    <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                        <input type="checkbox" name="unify_wcag_mode_enabled" value="1" <?php checked($wcag_enabled, true); ?>>
                        <strong>Enable WCAG 2.2 Enhancements</strong>
                    </label>
                    <p style="font-size: 12px; color: var(--unify-text-secondary); margin: 4px 0 0 24px;">
                        Loads additional accessibility features for screen readers, keyboard navigation, and assistive technologies.
                    </p>
                </div>
                
                <!-- Theme Selection with High Contrast -->
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-weight: 600; margin-bottom: 8px;">Banner Theme</label>
                    <?php $theme = Unify_Settings::get_option('unify_banner_theme'); ?>
                    <select name="unify_banner_theme" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
                        <option value="light" <?php selected($theme, 'light'); ?>>Light</option>
                        <option value="dark" <?php selected($theme, 'dark'); ?>>Dark</option>
                        <option value="high-contrast" <?php selected($theme, 'high-contrast'); ?>>High Contrast (7:1 ratio)</option>
                    </select>
                </div>
                
                <!-- Features List -->
                <div style="background: #f9fafb; padding: 12px; border-radius: 6px; margin-top: 12px;">
                    <strong style="font-size: 13px; display: block; margin-bottom: 8px;">Included Features:</strong>
                    <ul style="margin: 0; padding-left: 20px; font-size: 12px; color: var(--unify-text-secondary);">
                        <li>Full keyboard navigation (Tab, Escape, Enter)</li>
                        <li>Screen reader announcements and ARIA labels</li>
                        <li>Enhanced focus indicators (3-4px outlines)</li>
                        <li>Touch-friendly targets (44x44px minimum)</li>
                        <li>Reduced motion support</li>
                        <li>Windows High Contrast Mode support</li>
                    </ul>
                </div>
            <?php else : ?>
                <!-- Premium Upsell -->
                <div style="background: #f9fafb; padding: 20px; border-radius: 6px; border: 2px dashed #e5e7eb; text-align: center;">
                    <span class="dashicons dashicons-universal-access" style="font-size: 48px; color: #9ca3af; margin-bottom: 12px;"></span>
                    <h4 style="margin: 0 0 8px 0; color: #111827;">WCAG 2.2 Accessibility</h4>
                    <p style="color: var(--unify-text-secondary); margin: 0 0 16px 0; font-size: 13px;">
                        Make your cookie banner accessible to all users with industry-leading accessibility features:
                    </p>
                    <ul style="list-style: none; padding: 0; margin: 0 0 16px 0; font-size: 13px; color: #4b5563;">
                        <li style="padding: 4px 0;">✓ Full keyboard navigation</li>
                        <li style="padding: 4px 0;">✓ Screen reader optimized</li>
                        <li style="padding: 4px 0;">✓ High contrast mode</li>
                        <li style="padding: 4px 0;">✓ Touch-friendly targets</li>
                        <li style="padding: 4px 0;">✓ Reduced motion support</li>
                    </ul>
                    <a href="https://arwendigital.net/wordpress-plugin/unify-compliance" target="_blank" rel="noopener noreferrer" class="unify-btn unify-btn-premium" style="display: inline-block;">
                        <span class="dashicons dashicons-star-filled" style="font-size: 14px; vertical-align: middle;"></span>
                        Upgrade to Premium
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </form>

    <!-- Preview Column -->
    <div>
        <div class="unify-card" style="position: sticky; top: 20px;">
            <h3 class="unify-card-title" style="margin-bottom: 16px;">Live Preview</h3>
            
            <div style="border: 1px solid #ddd; background: #eee; height: 300px; position: relative; border-radius: 4px; overflow: hidden;">
                <div style="position: absolute; top: 50%; width: 100%; text-align: center; color: #999;">
                    Website Content
                </div>
                
                <!-- Mock Banner -->
                <div id="unify-preview-banner" style="position: absolute; bottom: 0; left: 0; right: 0; background: #fff; padding: 16px; border-top: 1px solid #ddd; box-shadow: 0 -2px 10px rgba(0,0,0,0.1); border-color: <?php echo esc_attr($primary_color); ?>;">
                    <p id="unify-preview-text" style="font-size: 12px; margin: 0 0 12px 0;"><?php echo esc_html(wp_unslash($banner_text)); ?></p>
                    <div style="display: flex; gap: 8px;">
                        <button id="unify-preview-accept-btn" style="background: <?php echo esc_attr($primary_color); ?>; color: #fff; border: none; padding: 6px 12px; border-radius: 4px; font-size: 12px; cursor: pointer;">Accept All</button>
                        <button style="background: #fff; color: #333; border: 1px solid #ddd; padding: 6px 12px; border-radius: 4px; font-size: 12px; cursor: pointer;">Customize</button>
                    </div>
                </div>
            </div>
            
             <div class="unify-premium-only" style="margin-top: 16px; padding: 12px; background: #f9fafb; border-radius: 6px; font-size: 13px;">
                <span class="unify-badge unify-badge-premium" style="margin-bottom: 6px;">Premium</span>
                <p style="margin: 0;">Upgrade to remove "Powered by Unify" branding.</p>
            </div>
        </div>
    </div>
</div>
