<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/gdpr/cookie-scanner.php
$cookies = Unify_Cookie_Scanner::get_cookies();
$last_scan = get_option('unify_last_scan_date');
$is_premium = unify_is_premium();
?>
<div class="unify-tabs">
    <a href="?page=unify-gdpr&tab=banner" class="unify-tab">Cookie Banner</a>
    <a href="?page=unify-gdpr&tab=queue" class="unify-tab">DSAR Requests</a>
    <a href="?page=unify-gdpr&tab=form" class="unify-tab">DSAR Form</a>
     <a href="?page=unify-gdpr&tab=scanner" class="unify-tab active"><span class="dashicons dashicons-shield" style="font-size: 16px; line-height: 1.3;"></span> Cookie Scanner<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
    <a href="?page=unify-gdpr&tab=automation" class="unify-tab"><span class="dashicons dashicons-lock"></span> DSAR Automation</a>
</div>

<div class="unify-card <?php echo !$is_premium ? 'unify-premium-only unify-locked' : ''; ?>">
    <?php if ( ! $is_premium ): ?>
        <div class="unify-locked-overlay">
            <span class="dashicons dashicons-lock unify-lock-icon"></span>
            <h3>Unlock Automatic Scanner</h3>
            <p>Automatically detect and categorize cookies to keep your policy up to date.</p>
            <a href="<?php echo esc_url( admin_url( 'admin.php?page=unify-gdpr&tab=scanner&action=scan&nonce=' . wp_create_nonce('unify_scan_cookies') ) ); ?>" class="unify-btn unify-btn-primary">
Activate License</a>
        </div>
    <?php endif; ?>

    <div class="<?php echo !$is_premium ? 'unify-blurred' : ''; ?>">
        <div class="unify-card-header">
            <div>
                <h2 class="unify-card-title">Automatic Cookie Scanner</h2>
                <p style="margin: 4px 0 0 0; color: var(--unify-text-secondary); font-size: 13px;">
                    <?php echo $last_scan ? 'Last scan: ' . esc_html( human_time_diff(strtotime($last_scan), current_time('timestamp')) ) . ' ago' : 'No scan performed yet.'; ?>
                </p>
            </div>
            
            <div style="display: flex; align-items: center; gap: 10px;">
                <button id="unify-run-scan" class="unify-btn unify-btn-primary">Scan Website Now</button>
            </div>
        </div>
        <p style="color: var(--unify-text-secondary); margin: 0 0 20px 0; font-size: 14px;">Scan your website to automatically detect and categorize cookies used by third-party scripts.</p>
        
        <div style="margin-bottom: 20px; background: #FFF7ED; border: 1px solid #FFEDD5; padding: 12px; border-radius: 4px; display: flex; gap: 10px;">
            <span class="dashicons dashicons-info" style="color: #EA580C;"></span>
            <p style="margin: 0; font-size: 13px; color: #9A3412;">
                The scanner will simulate a visitor session to detect cookies set by third-party scripts. 
                <strong>Note:</strong> Some cookies behind logins or user interactions may not be detected automatically.
            </p>
        </div>
        
        <table class="unify-table">
            <thead>
                <tr>
                    <th>Cookie Name</th>
                    <th>Category</th>
                    <th>Description</th>
                    <th>Expiry</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($cookies)) : ?>
                    <tr>
                        <td colspan="5" style="text-align: center; padding: 30px; color: #6b7280;">
                            No cookies detected. Run a scan to populate this list.
                        </td>
                    </tr>
                <?php else : ?>
                    <?php foreach ($cookies as $cookie) : ?>
                    <tr>
                        <td style="font-family: monospace; font-weight: 600;"><?php echo esc_html($cookie->cookie_name); ?></td>
                        <td>
                            <?php 
                            $cats = [
                                'necessary' => ['#DC2626', '#FEE2E2'],
                                'functional' => ['#D97706', '#FEF3C7'],
                                'analytics' => ['#2563EB', '#DBEAFE'],
                                'marketing' => ['#7C3AED', '#EDE9FE'],
                            ];
                            $colors = isset($cats[$cookie->category]) ? $cats[$cookie->category] : ['#4B5563', '#F3F4F6'];
                            ?>
                            <span style="background: <?php echo esc_attr($colors[1]); ?>; color: <?php echo esc_attr($colors[0]); ?>; padding: 4px 8px; border-radius: 99px; font-size: 11px; font-weight: 600; text-transform: uppercase;">
                                <?php echo esc_html( ucfirst($cookie->category) ); ?>
                            </span>
                        </td>
                        <td><?php echo esc_html($cookie->description); ?></td>
                        <td><?php echo esc_html($cookie->expiry); ?></td>
                        <td><span class="dashicons dashicons-yes" style="color: #10B981;"></span> Active</td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
        
        <script>
        jQuery(document).ready(function($) {
            $('#unify-run-scan').on('click', function() {
                const $btn = $(this);
                const originalText = $btn.text();
                $btn.text('Scanning... This may take a few seconds').prop('disabled', true);
                
                $.post(ajaxurl, {
                    action: 'unify_run_scan',
                    nonce: '<?php echo esc_js( wp_create_nonce('unify_admin_nonce') ); ?>'
                }, function(response) {
                    if (response.success) {
                        alert('Scan Complete! ' + response.data.message);
                        location.reload();
                    } else {
                        alert('Scan Failed: ' + response.data.message);
                        $btn.text(originalText).prop('disabled', false);
                    }
                });
            });
        });
        </script>
    </div>
</div>
