<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/gdpr/dsar-automation.php
$auto_sources = get_option('unify_dsar_auto_sources', ['core', 'comments', 'woocommerce']);
if (!is_array($auto_sources)) $auto_sources = [];
$auto_trigger = get_option('unify_dsar_auto_trigger_access', 0);
$is_premium = unify_is_premium();
?>
<div class="unify-tabs">
    <a href="?page=unify-gdpr&tab=banner" class="unify-tab">Cookie Banner</a>
    <a href="?page=unify-gdpr&tab=queue" class="unify-tab">DSAR Requests</a>
    <a href="?page=unify-gdpr&tab=form" class="unify-tab">DSAR Form</a>
     <a href="?page=unify-gdpr&tab=scanner" class="unify-tab"><span class="dashicons dashicons-shield"></span> Cookie Scanner<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
    <a href="?page=unify-gdpr&tab=automation" class="unify-tab active"><span class="dashicons dashicons-update" style="font-size: 16px; line-height: 1.3;"></span> DSAR Automation<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
</div>

<div class="unify-card <?php echo !$is_premium ? 'unify-premium-only unify-locked' : ''; ?>">
    <?php if ( ! $is_premium ): ?>
        <div class="unify-locked-overlay">
            <span class="dashicons dashicons-lock unify-lock-icon"></span>
            <h3>Unlock Automated Workflows</h3>
            <p>Automatically process access and deletion requests across all connected systems.</p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=unify-settings&tab=license')); ?>" class="unify-btn unify-btn-primary">Activate License</a>
        </div>
    <?php endif; ?>

    <div class="<?php echo !$is_premium ? 'unify-blurred' : ''; ?>">
        <div class="unify-card-header">
            <h2 class="unify-card-title">DSAR Workflow Automation</h2>
            <span class="unify-badge unify-badge-premium">Premium Active</span>
        </div>
        
        <div style="margin-bottom: 20px;">
            <p>Configure how Unify handles data export and deletion requests automatically.</p>
        </div>
        
        <form class="unify-ajax-form">
            <input type="hidden" name="action" value="unify_save_dsar_settings">
            <?php wp_nonce_field('unify_admin_nonce', 'nonce'); ?>
            <!-- Mock settings for automation -->
            <div style="margin-bottom: 20px;">
                <label style="display: block; font-weight: 600; margin-bottom: 8px;">Included Data Sources</label>
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_dsar_auto_sources[]" value="core" checked disabled> <strong>WordPress Core</strong> (User profile, posts, pages)
                </div>
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_dsar_auto_sources[]" value="comments" <?php checked(in_array('comments', $auto_sources)); ?>> <strong>Comments</strong> (Anonymization support)
                </div>
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_dsar_auto_sources[]" value="woocommerce" <?php checked(in_array('woocommerce', $auto_sources)); ?>> <strong>WooCommerce</strong> (Orders, addresses)
                </div>
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_dsar_auto_sources[]" value="media" <?php checked(in_array('media', $auto_sources)); ?>> <strong>Media Library</strong> (Uploaded files)
                </div>
            </div>
            
            <div style="margin-bottom: 20px;">
                <label style="display: block; font-weight: 600; margin-bottom: 8px;">Automation Triggers</label>
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_dsar_auto_trigger_access" value="1" <?php checked($auto_trigger, 1); ?>> Automatically process "Right to Access" requests after verification
                </div>
                <p style="font-size: 13px; color: var(--unify-text-secondary); margin-left: 24px;">Uses WP Cron to process requests in background.</p>
            </div>
            
            <button type="submit" class="unify-btn unify-btn-primary">Save Configuration</button>
        </form>
    </div>
</div>
