<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/gdpr/dsar-form-settings.php
$admin_email = Unify_Settings::get_option('unify_dsar_admin_email') ?: get_option('admin_email');
?>
<div class="unify-tabs">
    <a href="?page=unify-gdpr&tab=banner" class="unify-tab">Cookie Banner</a>
    <a href="?page=unify-gdpr&tab=queue" class="unify-tab">DSAR Requests</a>
    <a href="?page=unify-gdpr&tab=form" class="unify-tab active">DSAR Form</a>
     <a href="?page=unify-gdpr&tab=scanner" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> Cookie Scanner</a>
    <a href="?page=unify-gdpr&tab=automation" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> DSAR Automation</a>
</div>

<div class="unify-grid" style="grid-template-columns: 2fr 1fr;">
    <form class="unify-card unify-ajax-form">
        <input type="hidden" name="action" value="unify_save_dsar_settings">
        <?php wp_nonce_field('unify_admin_nonce', 'nonce'); ?>
        
        <div class="unify-card-header">
            <h3 class="unify-card-title">Form Settings</h3>
            <button type="submit" class="unify-btn unify-btn-primary">Save Settings</button>
        </div>
        <p style="color: var(--unify-text-secondary); margin: 0 0 20px 0; font-size: 14px;">Configure the shortcode and notification settings for your public Data Subject Access Request form.</p>
        
        <div style="margin-bottom: 20px;">
            <label style="display: block; font-weight: 600; margin-bottom: 8px;">Shortcode</label>
            <div style="background: #f3f4f6; padding: 12px; border-radius: 4px; font-family: monospace; border: 1px solid #d1d5db;">
                [unify_dsar_form]
            </div>
            <p style="font-size: 13px; color: var(--unify-text-secondary);">Paste this shortcode on any page to display the data request form.</p>
        </div>
        
        <div style="margin-bottom: 20px;">
            <label style="display: block; font-weight: 600; margin-bottom: 8px;">Admin Notification Email</label>
            <input type="email" name="unify_dsar_admin_email" value="<?php echo esc_attr($admin_email); ?>" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
            <p style="font-size: 13px; color: var(--unify-text-secondary);">Recipients for verified data requests.</p>
        </div>
        
        <div class="unify-premium-only" style="padding: 16px; background: #f9fafb; border-radius: 6px; border: 1px solid #e5e7eb;">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <div>
                     <strong style="display: block; margin-bottom: 4px;">CAPTCHA Protection</strong>
                     <p style="margin: 0; font-size: 13px; color: var(--unify-text-secondary);">Prevent spam requests with reCAPTCHA v3 or hCaptcha.</p>
                </div>
                <span class="unify-badge unify-badge-premium">Premium</span>
            </div>
        </div>
    </form>
    
    <div>
        <div class="unify-card">
            <h3 class="unify-card-title">How it works</h3>
            <ol style="margin: 0; padding-left: 20px; font-size: 14px; line-height: 1.6; color: var(--unify-text-secondary);">
                <li>User submits request form.</li>
                <li>They verify ownership via email code.</li>
                <li>Request appears in <strong>DSAR Queue</strong>.</li>
                <li>You process the request (Export/Delete).</li>
            </ol>
        </div>
    </div>
</div>
