<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// Retrieve real data
$current_status = isset($_GET['status']) ? sanitize_text_field($_GET['status']) : 'all';
$counts = Unify_DSAR_Queue::count_by_status();
$result = Unify_DSAR_Queue::get_requests($current_status);
$requests = $result['data'];
?>
<div class="unify-tabs">
    <a href="?page=unify-gdpr&tab=banner" class="unify-tab">Cookie Banner</a>
    <a href="?page=unify-gdpr&tab=queue" class="unify-tab active">DSAR Requests</a>
    <a href="?page=unify-gdpr&tab=form" class="unify-tab">DSAR Form</a>
     <a href="?page=unify-gdpr&tab=scanner" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> Cookie Scanner</a>
    <a href="?page=unify-gdpr&tab=automation" class="unify-tab locked"><span class="dashicons dashicons-lock"></span> DSAR Automation</a>
</div>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Data Subject Access Requests</h2>
        <div style="display: flex; gap: 8px;">
            <button class="unify-btn unify-btn-secondary unify-btn-sm">Export CSV</button>
        </div>
    </div>
    <p style="color: var(--unify-text-secondary); margin: 0 0 20px 0; font-size: 14px;">Manage specific requests from users to access, export, or delete their personal data.</p>
    
    <div style="margin-bottom: 16px;">
        <span style="font-weight: 600; margin-right: 12px;">Filter:</span>
        <a href="?page=unify-gdpr&tab=queue&status=all" class="unify-status-filter <?php echo $current_status === 'all' ? 'active' : ''; ?>">All (<?php echo intval($counts['all']); ?>)</a>
        <a href="?page=unify-gdpr&tab=queue&status=pending" class="unify-status-filter <?php echo $current_status === 'pending' ? 'active' : ''; ?>">Pending (<?php echo intval($counts['pending']); ?>)</a>
        <a href="?page=unify-gdpr&tab=queue&status=verified" class="unify-status-filter <?php echo $current_status === 'verified' ? 'active' : ''; ?>">Verified (<?php echo intval($counts['verified']); ?>)</a>
        <a href="?page=unify-gdpr&tab=queue&status=completed" class="unify-status-filter <?php echo $current_status === 'completed' ? 'active' : ''; ?>">Completed (<?php echo intval($counts['completed']); ?>)</a>
    </div>

    <table class="unify-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Email</th>
                <th>Type</th>
                <th>Date</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($requests)) : ?>
                <tr><td colspan="6" style="text-align:center; color: #6b7280; padding: 20px;">No requests found.</td></tr>
            <?php else : ?>
                <?php foreach ($requests as $req): ?>
                <tr>
                    <td>#<?php echo esc_html($req->id); ?></td>
                    <td><?php echo esc_html($req->email); ?></td>
                    <td><?php echo esc_html(ucfirst($req->request_type)); ?></td>
                    <td><?php echo esc_html(date_i18n(get_option('date_format'), strtotime($req->submitted_date))); ?></td>
                    <td>
                        <?php 
                        $badges = [
                            'pending' => 'unify-badge-warning', 
                            'verified' => 'unify-badge-success', 
                            'processing' => 'unify-badge-info',
                            'completed' => 'unify-badge-success',
                            'rejected' => 'unify-badge-error'
                        ];
                        $badge_class = isset($badges[$req->status]) ? $badges[$req->status] : 'unify-badge-default';
                        ?>
                        <span class="unify-badge <?php echo esc_attr($badge_class); ?>"><?php echo esc_html(ucfirst($req->status)); ?></span>
                    </td>
                    <td>
                        <?php if ($req->status === 'pending'): ?>
                            <button class="unify-btn unify-btn-secondary unify-btn-sm unify-action-btn" data-action="verify" data-id="<?php echo intval($req->id); ?>">Verify</button>
                        <?php endif; ?>
                        <?php if ($req->status === 'verified'): ?>
                            <button class="unify-btn unify-btn-primary unify-btn-sm unify-action-btn" data-action="complete" data-id="<?php echo intval($req->id); ?>">Complete</button>
                        <?php endif; ?>
                        <button class="unify-btn unify-btn-danger unify-btn-sm unify-action-btn" data-action="delete" data-id="<?php echo intval($req->id); ?>">Delete</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <script>
    jQuery(document).ready(function($) {
        $('.unify-action-btn').on('click', function(e) {
            e.preventDefault();
            const id = $(this).data('id');
            const action = $(this).data('action');
            const $btn = $(this);
            
            let confirm_message = '';
            if (action === 'verify') {
                confirm_message = 'Are you sure you want to mark this request as verified?';
            } else if (action === 'complete') {
                confirm_message = 'Are you sure you want to mark this request as completed?';
            } else if (action === 'delete') {
                confirm_message = 'Are you sure you want to delete this request? This action cannot be undone.';
            }

            if (!confirm(confirm_message)) return;
            
            $btn.prop('disabled', true).text('Updating...');
            
            $.post(ajaxurl, {
                action: 'unify_update_dsar_status',
                nonce: '<?php echo esc_attr(wp_create_nonce('unify_dsar_nonce')); ?>',
                id: id,
                status: action
            }, function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert(response.data.message);
                    $btn.prop('disabled', false).text('Mark Completed');
                }
            });
        });
    });
    </script>
</div>

<div class="unify-show-free unify-card" style="margin-top: 24px; background: #EEF2FF; border: 1px solid #C7D2FE;">
    <div style="display: flex; align-items: center; gap: 16px;">
        <div style="background: white; padding: 10px; border-radius: 50%;">
            <span class="dashicons dashicons-admin-generic" style="color: #4F46E5; font-size: 24px;"></span>
        </div>
        <div>
            <h3 style="margin: 0 0 4px 0;">Automate DSAR Processing</h3>
            <p style="margin: 0; font-size: 14px;">Premium allows you to automatically gather user data from WordPress, WooCommerce, and more, generating a ready-to-send ZIP file.</p>
        </div>
        <a href="#" class="unify-btn unify-btn-primary" style="margin-left: auto; white-space: nowrap;">Upgrade to Automate</a>
    </div>
</div>
