<?php
/**
 * View: Module Selector
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$all_modules    = Unify_Module_Manager::get_all_modules();
$active_modules = Unify_Module_Manager::get_active_modules();
?>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Compliance Modules</h2>
        <button id="unify_save_modules_btn" class="unify-btn unify-btn-primary">Save Changes</button>
    </div>

    <p style="padding: 0 20px; color: var(--unify-text-secondary);">
        Enable the compliance frameworks relevant to your jurisdiction or business needs. 
        Disabling a module will hide its features from the dashboard to keep your interface clean.
    </p>

    <div id="unify_modules_feedback" style="display:none; margin: 0 20px 20px; padding: 10px; border-radius: 4px;"></div>

    <form id="unify_modules_form">
        <table class="unify-table">
            <thead>
                <tr>
                    <th style="width: 50px;">Active</th>
                    <th>Module</th>
                    <th>Description</th>
                    <th style="width: 100px;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $all_modules as $slug => $module ) : 
                    $is_active = in_array( $slug, $active_modules, true );
                    $is_premium_only = ( $module['tier'] === 'premium' );
                    $is_coming_soon = ( $module['tier'] === 'coming_soon' );
                    $can_activate = Unify_Module_Manager::can_activate( $slug );
                    
                    // Logic to disable checkbox:
                    // 1. If it's coming soon -> Disabled
                    // 2. If it's premium and user is not premium -> Disabled
                    $disabled = ! $can_activate;
                ?>
                <tr class="<?php echo $is_premium_only ? 'unify-premium-row' : ''; ?>">
                    <td>
                        <label class="unify-switch">
                            <input type="checkbox" 
                                   name="modules[]" 
                                   value="<?php echo esc_attr( $slug ); ?>" 
                                   <?php checked( $is_active ); ?>
                                   <?php disabled( $disabled ); ?>>
                            <span class="unify-slider round"></span>
                        </label>
                    </td>
                    <td>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <?php if ( ! empty( $module['icon'] ) ) : ?>
                                <span class="dashicons <?php echo esc_attr( $module['icon'] ); ?>" style="color: var(--unify-primary); font-size: 20px;"></span>
                            <?php endif; ?>
                            <strong style="font-size: 15px;"><?php echo esc_html( $module['name'] ); ?></strong>
                        </div>
                    </td>
                    <td>
                        <?php echo esc_html( $module['description'] ); ?>
                        <?php if ( $is_premium_only && ! unify_is_premium() ) : ?>
                            <div style="margin-top: 5px;">
                                <a href="#" style="color: var(--unify-premium); font-weight: 500; text-decoration: none; font-size: 13px;">
                                    <span class="dashicons dashicons-lock" style="font-size: 14px; vertical-align: middle;"></span> 
                                    Upgrade to unlock
                                </a>
                            </div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ( $is_active ) : ?>
                            <span class="unify-badge unify-badge-success">Active</span>
                        <?php elseif ( $is_coming_soon ) : ?>
                            <span class="unify-badge">Coming Soon</span>
                        <?php elseif ( $is_premium_only && ! unify_is_premium() ) : ?>
                            <span class="unify-badge unify-badge-premium">Premium</span>
                        <?php else : ?>
                            <span class="unify-badge" style="background: #e5e7eb; color: #374151;">Inactive</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </form>
</div>

<style>
/* Simple CSS Switch toggle */
.unify-switch {
  position: relative;
  display: inline-block;
  width: 40px;
  height: 24px;
}
.unify-switch input { 
  opacity: 0;
  width: 0;
  height: 0;
}
.unify-slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}
.unify-slider:before {
  position: absolute;
  content: "";
  height: 16px;
  width: 16px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}
input:checked + .unify-slider {
  background-color: var(--unify-primary);
}
input:focus + .unify-slider {
  box-shadow: 0 0 1px var(--unify-primary);
}
input:checked + .unify-slider:before {
  -webkit-transform: translateX(16px);
  -ms-transform: translateX(16px);
  transform: translateX(16px);
}
/* Rounded sliders */
.unify-slider.round {
  border-radius: 34px;
}
.unify-slider.round:before {
  border-radius: 50%;
}
input:disabled + .unify-slider {
    background-color: #e5e7eb;
    cursor: not-allowed;
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    $('#unify_save_modules_btn').on('click', function(e) {
        e.preventDefault();
        
        var $btn = $(this);
        var originalText = $btn.text();
        $btn.text('Saving...').prop('disabled', true);
        
        var modules = [];
        $('input[name="modules[]"]:checked').each(function() {
            modules.push($(this).val());
        });

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'unify_save_modules',
                nonce: unify_vars.modules_nonce,
                modules: modules
            },
            success: function(response) {
                if (response.success) {
                    $('#unify_modules_feedback')
                        .removeClass('notice-error').addClass('notice-success')
                        .html('<p>' + response.data.message + '</p>')
                        .show();
                    
                    // Reload after a brief delay to reflect menu changes
                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                } else {
                    $('#unify_modules_feedback')
                        .removeClass('notice-success').addClass('notice-error')
                        .html('<p>' + (response.data.message || 'Error saving modules') + '</p>')
                        .show();
                    $btn.text(originalText).prop('disabled', false);
                }
            },
            error: function() {
                $('#unify_modules_feedback')
                    .removeClass('notice-success').addClass('notice-error')
                    .html('<p>Server error. Please try again.</p>')
                    .show();
                $btn.text(originalText).prop('disabled', false);
            }
        });
    });
});
</script>
