<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/nis2/activity-log.php

$filters = [
    'search' => isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '',
    'event_type' => isset($_GET['event_type']) ? sanitize_text_field($_GET['event_type']) : '',
    'severity' => isset($_GET['severity']) ? sanitize_text_field($_GET['severity']) : '',
    'date_start' => isset($_GET['date_start']) ? sanitize_text_field($_GET['date_start']) : '',
    'date_end' => isset($_GET['date_end']) ? sanitize_text_field($_GET['date_end']) : ''
];

$paged = isset($_GET['paged']) ? max(1, absint($_GET['paged'])) : 1;
$per_page = 20;
$offset = ($paged - 1) * $per_page;

$logs = Unify_Security_Logger::get_logs($per_page, $offset, $filters);
$total_logs = Unify_Security_Logger::count_logs($filters);
$total_pages = ceil($total_logs / $per_page);

?>
<?php
$is_premium = unify_is_premium();
?>
<div class="unify-tabs">
    <a href="?page=unify-nis2&tab=activity" class="unify-tab active">Activity Log</a>
    <a href="?page=unify-nis2&tab=settings" class="unify-tab">Settings</a>
    <a href="?page=unify-nis2&tab=policies" class="unify-tab">Policies</a>
    <a href="?page=unify-nis2&tab=vuln" class="unify-tab <?php echo !$is_premium ? 'locked' : ''; ?>"><?php if(!$is_premium): ?><span class="dashicons dashicons-lock"></span> <?php endif; ?>Vulnerability Scans</a>
</div>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Activity Log</h2>
        <form method="get" action="" style="display: flex; gap: 8px; flex-wrap: wrap; align-items: center;">
            <input type="hidden" name="page" value="unify-nis2">
            <input type="hidden" name="tab" value="activity">
            
            <select name="event_type" style="height: 32px;">
                <option value="">All Events</option>
                <option value="user_login" <?php selected($filters['event_type'], 'user_login'); ?>>Login</option>
                <option value="login_failed" <?php selected($filters['event_type'], 'login_failed'); ?>>Failed Login</option>
                <option value="plugin_change" <?php selected($filters['event_type'], 'plugin_change'); ?>>Plugin Change</option>
                <option value="user_role_change" <?php selected($filters['event_type'], 'user_role_change'); ?>>Role Change</option>
                <option value="option_updated" <?php selected($filters['event_type'], 'option_updated'); ?>>Option Updated</option>
            </select>
            
            <select name="severity" style="height: 32px;">
                <option value="">All Severities</option>
                <option value="info" <?php selected($filters['severity'], 'info'); ?>>Info</option>
                <option value="warning" <?php selected($filters['severity'], 'warning'); ?>>Warning</option>
                <option value="critical" <?php selected($filters['severity'], 'critical'); ?>>Critical</option>
            </select>
            
            <input type="date" name="date_start" value="<?php echo esc_attr($filters['date_start']); ?>" style="height: 32px; border: 1px solid var(--unify-border); border-radius: 4px;">
            <span style="color: var(--unify-text-secondary);">-</span>
            <input type="date" name="date_end" value="<?php echo esc_attr($filters['date_end']); ?>" style="height: 32px; border: 1px solid var(--unify-border); border-radius: 4px;">
            
            <input type="text" name="s" placeholder="Search logs..." value="<?php echo esc_attr($filters['search']); ?>" style="padding: 6px 12px; border: 1px solid var(--unify-border); border-radius: 4px; height: 32px;">
            
            <button type="submit" class="unify-btn unify-btn-secondary unify-btn-sm">Filter</button>
            <?php if (!empty(array_filter($filters))): ?>
                <a href="?page=unify-nis2&tab=activity" class="unify-btn unify-btn-link unify-btn-sm" style="color: var(--unify-error);">Reset</a>
            <?php endif; ?>
            
            <a href="#" id="unify-export-csv" class="unify-btn unify-btn-secondary unify-btn-sm" style="margin-left: auto;">Export CSV</a>
        </form>
    </div>

    <table class="unify-table">
        <thead>
            <tr>
                <th>Timestamp</th>
                <th>User</th>
                <th>Event Type</th>
                <th>IP Address</th>
                <th>Details</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($logs)): ?>
                <tr><td colspan="5" style="text-align: center; padding: 20px;">No logs found.</td></tr>
            <?php else: ?>
                <?php foreach ($logs as $log): 
                    $badge_class = 'unify-badge-default';
                    if ($log->severity === 'warning') $badge_class = 'unify-badge-warning';
                    if ($log->severity === 'critical') $badge_class = 'unify-badge-error';
                    
                    $user = get_userdata($log->user_id);
                    $username = $user ? $user->user_login : 'System/Guest';
                ?>
                <tr>
                    <td><?php echo esc_html( date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($log->created_at)) ); ?></td>
                    <td><?php echo esc_html($username); ?></td>
                    <td><span class="unify-badge <?php echo esc_attr($badge_class); ?>"><?php echo esc_html(str_replace('_', ' ', strtoupper($log->event_type))); ?></span></td>
                    <td><?php echo esc_html($log->ip_address); ?></td>
                    <td><?php echo esc_html($log->details); ?></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
    
    <?php if ($total_pages > 1): ?>
     <div style="display: flex; justify-content: flex-end; margin-top: 16px; gap: 4px;">
        <?php 
        $base_url = add_query_arg(array_filter($filters), admin_url('admin.php?page=unify-nis2&tab=activity'));
        
        if ($paged > 1): ?>
            <a href="<?php echo esc_url(add_query_arg('paged', $paged - 1, $base_url)); ?>" class="unify-btn unify-btn-secondary unify-btn-sm">&laquo; Prev</a>
        <?php endif; ?>
        
        <span style="padding: 4px 8px; line-height: 24px;"><?php echo esc_html(sprintf(
                    /* translators: 1: current page, 2: total pages */
                    __('Page %1$d of %2$d', 'unify-compliance'),
                    esc_html($paged),
                    esc_html($total_pages)
                )); ?></span>
        
        <?php if ($paged < $total_pages): ?>
            <a href="<?php echo esc_url(add_query_arg('paged', $paged + 1, $base_url)); ?>" class="unify-btn unify-btn-secondary unify-btn-sm">Next &raquo;</a>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    $('#unify-export-csv').on('click', function(e) {
        e.preventDefault();
        var url = ajaxurl + '?action=unify_export_nis2_logs&nonce=' + unify_vars.nonce;
        // Append current filters
        var search = $('input[name="s"]').val();
        var event = $('select[name="event_type"]').val();
        var severity = $('select[name="severity"]').val();
        var start = $('input[name="date_start"]').val();
        var end = $('input[name="date_end"]').val();
        
        if (search) url += '&search=' + encodeURIComponent(search);
        if (event) url += '&event_type=' + encodeURIComponent(event);
        if (severity) url += '&severity=' + encodeURIComponent(severity);
        if (start) url += '&date_start=' + encodeURIComponent(start);
        if (end) url += '&date_end=' + encodeURIComponent(end);
        
        window.location.href = url;
    });
});
</script>
