<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/nis2/dashboard.php
$tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'logs';

// Ensure logger loaded
if (!class_exists('Unify_Security_Logger')) {
    require_once Unify_PLUGIN_DIR . 'includes/nis2/class-unify-security-logger.php';
}
?>
<div class="wrap">
    <div style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 20px;">
        <h1 class="wp-heading-inline">NIS2 Compliance Center</h1>
        <div><span class="unify-badge unify-badge-success">Monitoring Active</span></div>
    </div>
    
    <?php
    switch ($tab) {
        case 'settings':
            require_once dirname(__FILE__) . '/settings.php';
            break;
        case 'vulnerabilities':
        case 'vuln':
            require_once dirname(__FILE__) . '/vulnerabilities.php';
            break;
        case 'policies':
            // We need to create this file or check if it exists (it doesn't seem to be in the list earlier, likely inline previously)
            // Wait, looking at Step 876, policies was inline. I should extract it or keep inline for now if file doesn't exist.
            // I'll create policies.php in the next step. For now, I'll keep the logic if I can, or point to it.
            // Let's assume I will create it.
            if (file_exists(dirname(__FILE__) . '/policies.php')) {
                require_once dirname(__FILE__) . '/policies.php';
            } else {
                echo '<div class="unify-card"><p>Policies view missing.</p></div>';
            }
            break;
        case 'logs':
        case 'activity':
        default:
            require_once dirname(__FILE__) . '/activity-log.php';
            break;
    }
    ?>
</div>
