<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/nis2/policies.php

$policies = Unify_Policy_Manager::get_policies();
$is_premium = unify_is_premium();
?>

<div class="unify-tabs">
    <a href="?page=unify-nis2&tab=activity" class="unify-tab">Activity Log</a>
    <a href="?page=unify-nis2&tab=settings" class="unify-tab">Settings</a>
    <a href="?page=unify-nis2&tab=policies" class="unify-tab active">Policies</a>
    <a href="?page=unify-nis2&tab=vuln" class="unify-tab <?php echo !$is_premium ? 'locked' : ''; ?>"><?php if(!$is_premium): ?><span class="dashicons dashicons-lock"></span> <?php endif; ?>Vulnerability Scans</a>
</div>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Security Policies</h2>
        <button id="unify-add-policy-btn" class="unify-btn unify-btn-primary">Create New Policy</button>
    </div>
    
    <table class="unify-table" id="unify-policies-table">
        <thead>
            <tr>
                <th>Policy Title</th>
                <th>Version</th>
                <th>Status</th>
                <th>Last Updated</th>
                <th style="text-align: right;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($policies)): ?>
                <tr>
                    <td colspan="5" style="text-align: center; padding: 20px; color: var(--unify-text-secondary);">
                        No policies found. Create your first security policy to track compliance.
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($policies as $policy): 
                    $badge_class = $policy->status === 'published' ? 'unify-badge-success' : 'unify-badge-default';
                    $updated_by = get_userdata($policy->updated_by);
                    $author_name = $updated_by ? $updated_by->user_login : 'Unknown';
                ?>
                <tr data-id="<?php echo esc_attr($policy->id); ?>">
                    <td>
                        <strong><?php echo esc_html($policy->title); ?></strong>
                    </td>
                    <td><span class="unify-badge unify-badge-default">v<?php echo esc_html($policy->version); ?></span></td>
                    <td><span class="unify-badge <?php echo esc_attr($badge_class); ?>"><?php echo esc_html( ucfirst($policy->status) ); ?></span></td>
                    <td style="font-size: 13px; color: var(--unify-text-secondary);">
                        <?php echo esc_html( date_i18n(get_option('date_format'), strtotime($policy->last_updated)) ); ?> by <?php echo esc_html($author_name); ?>
                    </td>
                    <td style="text-align: right;">
                        <button class="unify-btn unify-btn-secondary unify-btn-sm unify-edit-policy" data-id="<?php echo esc_attr($policy->id); ?>">Edit</button>
                        <button class="unify-btn unify-btn-danger unify-btn-sm unify-delete-policy" data-id="<?php echo esc_attr($policy->id); ?>">Delete</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Policy Modal -->
<div id="unify-policy-modal" class="unify-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; align-items: center; justify-content: center;">
    <div class="unify-modal-content" style="background: white; width: 600px; max-width: 90%; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.15); display: flex; flex-direction: column;">
        <div class="unify-modal-header" style="padding: 16px 20px; border-bottom: 1px solid var(--unify-border); display: flex; justify-content: space-between; align-items: center;">
            <h3 style="margin: 0; font-size: 18px;" id="unify-modal-title">Create Policy</h3>
            <button id="unify-close-modal" style="background: none; border: none; cursor: pointer; font-size: 20px;">&times;</button>
        </div>
        
        <div class="unify-modal-body" style="padding: 20px;">
            <form id="unify-policy-form">
                <input type="hidden" name="id" id="unify-policy-id" value="0">
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-weight: 600; margin-bottom: 4px;">Policy Title</label>
                    <input type="text" name="title" id="unify-policy-title" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;" required>
                </div>
                
                <div style="display: flex; gap: 16px; margin-bottom: 16px;">
                    <div style="flex: 1;">
                        <label style="display: block; font-weight: 600; margin-bottom: 4px;">Version</label>
                        <input type="text" name="version" id="unify-policy-version" value="1.0" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
                    </div>
                    <div style="flex: 1;">
                        <label style="display: block; font-weight: 600; margin-bottom: 4px;">Status</label>
                        <select name="status" id="unify-policy-status" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
                            <option value="draft">Draft</option>
                            <option value="published">Published</option>
                        </select>
                    </div>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; font-weight: 600; margin-bottom: 4px;">Policy Content</label>
                    <textarea name="content" id="unify-policy-content" rows="10" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;" placeholder="Enter policy details here..."></textarea>
                </div>
            </form>
        </div>
        
        <div class="unify-modal-footer" style="padding: 16px 20px; border-top: 1px solid var(--unify-border); display: flex; justify-content: flex-end; gap: 8px;">
            <button class="unify-btn unify-btn-secondary" id="unify-cancel-modal">Cancel</button>
            <button class="unify-btn unify-btn-primary" id="unify-save-policy">Save Policy</button>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    const $modal = $('#unify-policy-modal');
    const $form = $('#unify-policy-form');
    
    // Open Modal (Create)
    $('#unify-add-policy-btn').on('click', function() {
        $('#unify-modal-title').text('Create Policy');
        $('#unify-policy-id').val('0');
        $form[0].reset();
        $modal.css('display', 'flex');
    });
    
    // Open Modal (Edit)
    $('.unify-edit-policy').on('click', function() {
        const id = $(this).data('id');
        $('#unify-modal-title').text('Edit Policy');
        
        // Fetch data
        $.post(ajaxurl, {
            action: 'unify_get_policy',
            id: id,
            nonce: unify_vars.nonce
        }, function(response) {
            if (response.success) {
                const data = response.data;
                $('#unify-policy-id').val(data.id);
                $('#unify-policy-title').val(data.title);
                $('#unify-policy-version').val(data.version);
                $('#unify-policy-status').val(data.status);
                $('#unify-policy-content').val(data.content);
                $modal.css('display', 'flex');
            } else {
                alert('Error fetching policy');
            }
        });
    });
    
    // Close Modal
    $('#unify-close-modal, #unify-cancel-modal').on('click', function(e) {
        e.preventDefault();
        $modal.hide();
    });
    
    // Save Policy
    $('#unify-save-policy').on('click', function(e) {
        e.preventDefault();
        const $btn = $(this);
        $btn.prop('disabled', true).text('Saving...');
        
        const data = $form.serialize() + '&action=unify_save_policy&nonce=' + unify_vars.nonce;
        
        $.post(ajaxurl, data, function(response) {
            $btn.prop('disabled', false).text('Save Policy');
            if (response.success) {
                $modal.hide();
                location.reload(); 
            } else {
                alert('Error: ' + (response.data.message || 'Unknown error'));
            }
        });
    });
    
    // Delete Policy
    $('.unify-delete-policy').on('click', function() {
        if (!confirm('Are you sure you want to delete this policy? This cannot be undone.')) return;
        
        const id = $(this).data('id');
        const $row = $(this).closest('tr');
        
        $.post(ajaxurl, {
            action: 'unify_delete_policy',
            id: id,
            nonce: unify_vars.nonce
        }, function(response) {
            if (response.success) {
                $row.fadeOut(function() { $(this).remove(); });
            } else {
                alert('Error: ' + response.data.message);
            }
        });
    });
});
</script>
