<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$log_events = get_option('unify_nis2_log_events', ['login', 'failed_login', 'plugin_change', 'user_role_change']);
$retention = absint(get_option('unify_nis2_log_retention', 90));
$anonymize_ip = get_option('unify_nis2_anonymize_ip', 0);
$exclude_admins = get_option('unify_nis2_exclude_admins', 0);
$is_premium = unify_is_premium();
?>
<div class="unify-tabs">
    <a href="?page=unify-nis2&tab=activity" class="unify-tab">Activity Log</a>
    <a href="?page=unify-nis2&tab=settings" class="unify-tab active">Settings</a>
    <a href="?page=unify-nis2&tab=policies" class="unify-tab">Policies</a>
    <a href="?page=unify-nis2&tab=vuln" class="unify-tab <?php echo !$is_premium ? 'locked' : ''; ?>"><?php if(!$is_premium): ?><span class="dashicons dashicons-lock"></span> <?php endif; ?>Vulnerability Scans</a>
</div>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Logging Configuration</h2>
        <button id="unify-save-nis2-settings" class="unify-btn unify-btn-primary">Save Changes</button>
    </div>

    <form id="unify-nis2-settings-form">
        <div class="unify-grid" style="grid-template-columns: 1fr 1fr; gap: 40px;">
            <div>
                <h3 style="margin-top: 0;">Event Types</h3>
                <p style="color: var(--unify-text-secondary); margin-bottom: 20px;">Select which events to record in the activity log.</p>
                
                <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_log_events[]" value="login" <?php checked(in_array('login', $log_events)); ?>> Login / Logout
                </div>
                 <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_log_events[]" value="failed_login" <?php checked(in_array('failed_login', $log_events)); ?>> Failed Logins
                </div>
                 <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_log_events[]" value="plugin_change" <?php checked(in_array('plugin_change', $log_events)); ?>> Plugin & Theme Changes
                </div>
                 <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_log_events[]" value="user_role_change" <?php checked(in_array('user_role_change', $log_events)); ?>> User Role Changes
                </div>
            </div>

            <div>
                <h3 style="margin-top: 0;">Retention & Privacy</h3>
                
                <div style="margin-bottom: 20px;">
                    <label style="display: block; font-weight: 600; margin-bottom: 8px;">Log Retention Period</label>
                    <select name="unify_nis2_log_retention" style="width: 100%; padding: 8px; border: 1px solid var(--unify-border); border-radius: 4px;">
                        <option value="30" <?php selected($retention, 30); ?>>30 Days</option>
                        <option value="90" <?php selected($retention, 90); ?>>90 Days (Recommended)</option>
                        <option value="180" <?php selected($retention, 180); ?>>180 Days</option>
                        <option value="365" <?php selected($retention, 365); ?>>1 Year</option>
                    </select>
                    <p style="font-size: 12px; color: var(--unify-text-secondary); margin-top: 4px;">Logs older than this will be automatically deleted.</p>
                </div>
                
                 <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_anonymize_ip" value="1" <?php checked($anonymize_ip, 1); ?>> Anonymize IP Addresses (GDPR Compliance)
                </div>
                 <div class="unify-status-item">
                    <input type="checkbox" name="unify_nis2_exclude_admins" value="1" <?php checked($exclude_admins, 1); ?>> Disable logging for Administrators
                </div>
            </div>
        </div>
    </form>
</div>

<script>
jQuery(document).ready(function($) {
    $('#unify-save-nis2-settings').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        $btn.prop('disabled', true).text('Saving...');
        
        var data = $('#unify-nis2-settings-form').serialize();
        data += '&action=unify_save_nis2_settings&nonce=' + unify_vars.nis2_nonce;
        
        $.post(ajaxurl, data, function(response) {
            $btn.prop('disabled', false).text('Save Changes');
            if (response.success) {
                alert('Settings saved successfully!');
            } else {
                alert('Error: ' + (response.data.message || 'Unknown error'));
            }
        });
    });
});
</script>
