<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// admin/views/nis2/vulnerabilities.php

$is_premium = unify_is_premium();
$last_scan = Unify_Vulnerability_Scanner::get_last_scan();
$results = $last_scan['results'];
$last_run = $last_scan['time'];

// Group vulnerabilities by severity
$grouped = [
    'critical' => [],
    'high' => [],
    'medium' => [],
    'low' => [],
    'info' => []
];

foreach ($results as $vuln) {
    $severity = $vuln['severity'];
    if (isset($grouped[$severity])) {
        $grouped[$severity][] = $vuln;
    }
}

// Get manual vulnerability rules
$manual_rules = Unify_Vulnerability_Scanner::get_manual_vulnerability_rules();
?>

<div class="unify-tabs">
    <a href="?page=unify-nis2&tab=activity" class="unify-tab">Activity Log</a>
    <a href="?page=unify-nis2&tab=settings" class="unify-tab">Settings</a>
    <a href="?page=unify-nis2&tab=policies" class="unify-tab">Policies</a>
    <a href="?page=unify-nis2&tab=vuln" class="unify-tab active"><?php if(!$is_premium): ?><span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span> <?php endif; ?>Vulnerability Scans</a>
</div>

<div class="unify-card <?php echo !$is_premium ? 'unify-premium-only unify-locked' : ''; ?>">
    <?php if ( ! $is_premium ): ?>
        <div class="unify-locked-overlay">
            <span class="dashicons dashicons-lock unify-lock-icon"></span>
            <h3>Unlock Vulnerability Scanner</h3>
            <p>Scan your WordPress installation for security vulnerabilities in core, plugins, and themes.</p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=unify-settings&tab=license')); ?>" class="unify-btn unify-btn-primary">Activate License</a>
        </div>
    <?php endif; ?>

    <div class="<?php echo !$is_premium ? 'unify-blurred' : ''; ?>">
    <div class="unify-card-header">
        <div>
            <h2 class="unify-card-title">Vulnerability Scanner</h2>
            <p style="margin: 4px 0 0; color: var(--unify-text-secondary); font-size: 13px;">
                Hybrid scanner using WordPress.org API, core CVE detection, and heuristic analysis.
            </p>
        </div>
        <div style="text-align: right;">
            <button id="unify-run-scan" class="unify-btn unify-btn-primary">Scan Now</button>
            <button id="unify-manage-rules" class="unify-btn unify-btn-secondary" style="margin-left: 8px;">Manage Custom Rules</button>
            <?php if (!empty($results)): ?>
                <button id="unify-export-report" class="unify-btn unify-btn-secondary" style="margin-left: 8px;">Export Report</button>
            <?php endif; ?>
            <div id="unify-last-scan-time" style="font-size: 12px; color: var(--unify-text-secondary); margin-top: 4px;">
                <?php if ($last_run): ?>
                    Last scan: <?php echo esc_html( date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($last_run)) ); ?>
                <?php else: ?>
                    No scans run yet.
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Scan Options -->
    <div style="padding: 16px; background: var(--unify-bg-subtle); border-radius: 6px; margin-bottom: 20px;">
        <h3 style="margin: 0 0 12px; font-size: 14px; font-weight: 600;">Scan Options</h3>
        <div style="display: flex; gap: 20px; flex-wrap: wrap;">
            <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                <input type="checkbox" id="scan-opt-core" checked> WordPress Core
            </label>
            <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                <input type="checkbox" id="scan-opt-plugins" checked> Plugins
            </label>
            <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                <input type="checkbox" id="scan-opt-themes" checked> Themes
            </label>
            <label style="display: flex; align-items: center; gap: 6px; cursor: pointer;">
                <input type="checkbox" id="scan-opt-heuristics" checked> Heuristic Analysis
            </label>
        </div>
    </div>
    
    <div id="unify-scan-results">
        <?php if (empty($results) && !$last_run): ?>
            <div style="text-align: center; padding: 40px; background: var(--unify-bg-subtle); border-radius: 8px; margin-top: 20px;">
                <span class="dashicons dashicons-shield-alt" style="font-size: 48px; width: 48px; height: 48px; color: var(--unify-text-secondary);"></span>
                <h3 style="margin: 16px 0 8px;">No Scan Results</h3>
                <p style="color: var(--unify-text-secondary); margin-bottom: 24px;">Run a scan to detect potential security issues in your WordPress environment.</p>
                <button class="unify-btn unify-btn-secondary" onclick="document.getElementById('unify-run-scan').click()">Start First Scan</button>
            </div>
        <?php elseif (empty($results) && $last_run): ?>
             <div class="unify-notice unify-notice-success" style="margin-top: 20px;">
                <span class="dashicons dashicons-yes"></span> No vulnerabilities found in the last scan. Great job!
            </div>
        <?php else: ?>
            <!-- Summary Cards -->
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 12px; margin-bottom: 24px;">
                <div style="background: #ffebee; padding: 16px; border-radius: 6px; border-left: 4px solid #d32f2f;">
                    <div style="font-size: 24px; font-weight: 600; color: #d32f2f;"><?php echo count($grouped['critical']); ?></div>
                    <div style="font-size: 12px; color: #c62828; margin-top: 4px;">Critical</div>
                </div>
                <div style="background: #fff3e0; padding: 16px; border-radius: 6px; border-left: 4px solid #f57c00;">
                    <div style="font-size: 24px; font-weight: 600; color: #f57c00;"><?php echo count($grouped['high']); ?></div>
                    <div style="font-size: 12px; color: #ef6c00; margin-top: 4px;">High</div>
                </div>
                <div style="background: #fff8e1; padding: 16px; border-radius: 6px; border-left: 4px solid #fbc02d;">
                    <div style="font-size: 24px; font-weight: 600; color: #fbc02d;"><?php echo count($grouped['medium']); ?></div>
                    <div style="font-size: 12px; color: #f9a825; margin-top: 4px;">Medium</div>
                </div>
                <div style="background: #e8f5e9; padding: 16px; border-radius: 6px; border-left: 4px solid #66bb6a;">
                    <div style="font-size: 24px; font-weight: 600; color: #66bb6a;"><?php echo count($grouped['low']) + count($grouped['info']); ?></div>
                    <div style="font-size: 12px; color: #43a047; margin-top: 4px;">Low / Info</div>
                </div>
            </div>
            
            <!-- Vulnerabilities Table -->
            <?php foreach (['critical', 'high', 'medium', 'low', 'info'] as $severity_level): ?>
                <?php if (!empty($grouped[$severity_level])): ?>
                    <h3 style="margin: 24px 0 12px; font-size: 16px; text-transform: capitalize;"><?php echo esc_html($severity_level); ?> Severity (<?php echo count($grouped[$severity_level]); ?>)</h3>
                    <table class="unify-table" style="margin-bottom: 20px;">
                        <thead>
                            <tr>
                                <th style="width: 40px;"></th>
                                <th>Component</th>
                                <th>Type</th>
                                <th>Issue</th>
                                <th>Version</th>
                                <th style="text-align: right;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($grouped[$severity_level] as $vuln): 
                                $badge_class = 'unify-badge-default';
                                if ($vuln['severity'] === 'info') $badge_class = 'unify-badge-info';
                                if ($vuln['severity'] === 'low') $badge_class = 'unify-badge-success';
                                $severity_color = 'var(--unify-text-secondary)'; // Default color
                                if ($vuln['severity'] === 'info') { $badge_class = 'unify-badge-info'; $severity_color = '#2196f3'; }
                                if ($vuln['severity'] === 'low') { $badge_class = 'unify-badge-success'; $severity_color = '#4caf50'; }
                                if ($vuln['severity'] === 'medium') { $badge_class = 'unify-badge-warning'; $severity_color = '#ff9800'; }
                                if ($vuln['severity'] === 'high' || $vuln['severity'] === 'critical') { $badge_class = 'unify-badge-error'; $severity_color = '#f44336'; }
                                
                                $type_icon = 'admin-plugins';
                                if ($vuln['type'] === 'core') $type_icon = 'wordpress-alt';
                                if ($vuln['type'] === 'theme') $type_icon = 'admin-appearance';
                            ?>
                            <tr>
                                <td>
                                    <div class="unify-vuln-icon" style="background: <?php echo esc_attr($severity_color); ?>20; color: <?php echo esc_attr($severity_color); ?>;">
                                        <span class="dashicons dashicons-<?php echo esc_attr($type_icon); ?>"></span>
                                    </div>
                                </td>
                                <td>
                                    <strong><?php echo esc_html($vuln['name']); ?></strong>
                                    <?php if (!empty($vuln['manual'])): ?>
                                        <span class="unify-badge unify-badge-info" style="margin-left: 6px; font-size: 10px;">Custom Rule</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo esc_html( ucfirst($vuln['type']) ); ?></td>
                                <td>
                                    <div style="margin-bottom: 4px;"><?php echo esc_html($vuln['issue']); ?></div>
                                    <?php if (!empty($vuln['cve'])): ?>
                                        <span class="unify-badge unify-badge-default" style="font-size: 10px;"><?php echo esc_html($vuln['cve']); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div style="font-size: 12px;">
                                        <div>Current: <strong><?php echo esc_html($vuln['current_version'] ?? 'N/A'); ?></strong></div>
                                        <?php if (!empty($vuln['fixed_version'])): ?>
                                            <div style="color: var(--unify-success);">Fixed: <?php echo esc_html($vuln['fixed_version']); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td style="text-align: right;">
                                    <button class="unify-view-vuln-details unify-btn unify-btn-secondary unify-btn-sm" 
                                       data-vuln='<?php echo json_encode($vuln); ?>'>Details</button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Vulnerability Details Modal -->
<div id="unify-vuln-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 100000; align-items: center; justify-content: center;">
    <div style="background: white; border-radius: 8px; max-width: 600px; width: 90%; max-height: 80vh; overflow-y: auto; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
        <div style="padding: 24px; border-bottom: 1px solid #e0e0e0; display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-size: 18px;" id="unify-vuln-modal-title">Vulnerability Details</h2>
            <button id="unify-close-modal" style="background: none; border: none; font-size: 24px; cursor: pointer; color: #666; line-height: 1;">&times;</button>
        </div>
        <div style="padding: 24px;" id="unify-vuln-modal-content">
            <!-- Content will be populated by JavaScript -->
        </div>
    </div>
</div>

<!-- Manage Custom Rules Modal -->
<div id="unify-rules-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 100000; align-items: center; justify-content: center;">
    <div style="background: white; border-radius: 8px; max-width: 800px; width: 90%; max-height: 80vh; overflow-y: auto; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
        <div style="padding: 24px; border-bottom: 1px solid #e0e0e0; display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-size: 18px;">Manage Custom Vulnerability Rules</h2>
            <button id="unify-close-rules-modal" style="background: none; border: none; font-size: 24px; cursor: pointer; color: #666; line-height: 1;">&times;</button>
        </div>
        <div style="padding: 24px;">
            <button id="unify-add-rule" class="unify-btn unify-btn-primary" style="margin-bottom: 16px;">Add New Rule</button>
            
            <table class="unify-table" id="unify-rules-table">
                <thead>
                    <tr>
                        <th>Target</th>
                        <th>Severity</th>
                        <th>Title</th>
                        <th>CVE</th>
                        <th style="text-align: right;">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($manual_rules)): ?>
                        <tr>
                            <td colspan="5" style="text-align: center; padding: 24px; color: var(--unify-text-secondary);">
                                No custom rules defined yet.
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($manual_rules as $rule): ?>
                            <tr>
                                <td>
                                    <div><strong><?php echo esc_html($rule['target_slug']); ?></strong></div>
                                    <div style="font-size: 12px; color: var(--unify-text-secondary);"><?php echo esc_html( ucfirst($rule['target_type']) ); ?></div>
                                </td>
                                <td>
                                    <?php
                                    $badge_class = 'unify-badge-default';
                                    if ($rule['severity'] === 'medium') $badge_class = 'unify-badge-warning';
                                    if ($rule['severity'] === 'high' || $rule['severity'] === 'critical') $badge_class = 'unify-badge-error';
                                    ?>
                                    <span class="unify-badge <?php echo esc_attr($badge_class); ?>"><?php echo esc_html( ucfirst($rule['severity']) ); ?></span>
                                </td>
                                <td><?php echo esc_html($rule['title']); ?></td>
                                <td><?php echo esc_html($rule['cve_id'] ?: 'N/A'); ?></td>
                                <td style="text-align: right;">
                                    <button class="unify-edit-rule unify-btn unify-btn-secondary unify-btn-sm" data-id="<?php echo esc_attr($rule['id']); ?>">Edit</button>
                                    <button class="unify-delete-rule unify-btn unify-btn-danger unify-btn-sm" data-id="<?php echo esc_attr($rule['id']); ?>" style="margin-left: 4px;">Delete</button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add/Edit Rule Modal -->
<div id="unify-rule-form-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 100001; align-items: center; justify-content: center;">
    <div style="background: white; border-radius: 8px; max-width: 600px; width: 90%; max-height: 80vh; overflow-y: auto; box-shadow: 0 4px 20px rgba(0,0,0,0.15);">
        <div style="padding: 24px; border-bottom: 1px solid #e0e0e0; display: flex; justify-content: space-between; align-items: center;">
            <h2 style="margin: 0; font-size: 18px;" id="unify-rule-form-title">Add Vulnerability Rule</h2>
            <button id="unify-close-rule-form" style="background: none; border: none; font-size: 24px; cursor: pointer; color: #666; line-height: 1;">&times;</button>
        </div>
        <div style="padding: 24px;">
            <form id="unify-rule-form">
                <input type="hidden" id="rule-id" name="id">
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Target Type *</label>
                    <select id="rule-target-type" name="target_type" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                        <option value="plugin">Plugin</option>
                        <option value="theme">Theme</option>
                        <option value="core">WordPress Core</option>
                    </select>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Target Slug *</label>
                    <input type="text" id="rule-target-slug" name="target_slug" required placeholder="e.g., akismet" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                    <small style="color: var(--unify-text-secondary);">Plugin/theme slug or 'wordpress' for core</small>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Severity *</label>
                    <select id="rule-severity" name="severity" required style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                        <option value="info">Info</option>
                        <option value="low">Low</option>
                        <option value="medium">Medium</option>
                        <option value="high">High</option>
                        <option value="critical">Critical</option>
                    </select>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Title *</label>
                    <input type="text" id="rule-title" name="title" required placeholder="e.g., SQL Injection vulnerability" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Description</label>
                    <textarea id="rule-description" name="description" rows="3" placeholder="Detailed description of the vulnerability" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;"></textarea>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Affected Versions</label>
                    <input type="text" id="rule-affected-versions" name="affected_versions" placeholder="e.g., <= 1.2.3 or 1.2.*" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                    <small style="color: var(--unify-text-secondary);">Comma-separated. Supports wildcards (*) and operators (<=, >=, <, >)</small>
                </div>
                
                <div style="margin-bottom: 16px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">Fixed Version</label>
                    <input type="text" id="rule-fixed-version" name="fixed_version" placeholder="e.g., 1.2.4" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                </div>
                
                <div style="margin-bottom: 24px;">
                    <label style="display: block; margin-bottom: 6px; font-weight: 500;">CVE ID</label>
                    <input type="text" id="rule-cve-id" name="cve_id" placeholder="e.g., CVE-2023-12345" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                </div>
                
                <div style="display: flex; gap: 8px; justify-content: flex-end;">
                    <button type="button" id="unify-cancel-rule-form" class="unify-btn unify-btn-secondary">Cancel</button>
                    <button type="submit" class="unify-btn unify-btn-primary">Save Rule</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Run Scan
    $('#unify-run-scan').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $results = $('#unify-scan-results');
        
        $btn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> Scanning...');
        
        var options = {
            check_core: $('#scan-opt-core').is(':checked'),
            check_plugins: $('#scan-opt-plugins').is(':checked'),
            check_themes: $('#scan-opt-themes').is(':checked'),
            check_heuristics: $('#scan-opt-heuristics').is(':checked')
        };
        
        $.post(ajaxurl, {
            action: 'unify_run_vuln_scan',
            nonce: unify_vars.nonce,
            ...options
        }, function(response) {
            $btn.prop('disabled', false).text('Scan Now');
            
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data || 'Scan failed'));
            }
        });
    });
    
    // Export Report
    $('#unify-export-report').on('click', function(e) {
        e.preventDefault();
        window.location.href = ajaxurl + '?action=unify_export_vuln_report&nonce=' + unify_vars.nonce;
    });
    
    // View Details Modal
    $(document).on('click', '.unify-view-vuln-details', function(e) {
        e.preventDefault();
        var vuln = $(this).data('vuln');
        
        var badgeClass = 'unify-badge-default';
        if (vuln.severity === 'info') badgeClass = 'unify-badge-info';
        if (vuln.severity === 'low') badgeClass = 'unify-badge-success';
        if (vuln.severity === 'medium') badgeClass = 'unify-badge-warning';
        if (vuln.severity === 'high' || vuln.severity === 'critical') badgeClass = 'unify-badge-error';
        
        var content = '<div style="margin-bottom: 20px;">' +
            '<div style="margin-bottom: 12px;"><span class="unify-badge ' + badgeClass + '">' + vuln.severity.charAt(0).toUpperCase() + vuln.severity.slice(1) + ' Severity</span></div>' +
            '<h3 style="margin: 0 0 8px; font-size: 16px;">' + vuln.issue + '</h3>' +
            '</div>' +
            '<div style="background: #f9f9f9; padding: 16px; border-radius: 6px; margin-bottom: 16px;">' +
            '<div style="margin-bottom: 8px;"><strong>Component:</strong> ' + vuln.name + '</div>' +
            '<div style="margin-bottom: 8px;"><strong>Type:</strong> ' + vuln.type.charAt(0).toUpperCase() + vuln.type.slice(1) + '</div>' +
            '<div style="margin-bottom: 8px;"><strong>Current Version:</strong> ' + (vuln.current_version || 'N/A') + '</div>';
        
        if (vuln.fixed_version) {
            content += '<div style="margin-bottom: 8px;"><strong>Fixed Version:</strong> ' + vuln.fixed_version + '</div>';
        }
        
        if (vuln.cve) {
            content += '<div style="margin-bottom: 8px;"><strong>CVE:</strong> ' + vuln.cve + '</div>';
        }
        
        content += '</div>' +
            '<div style="background: #e8f5e9; padding: 16px; border-radius: 6px; border-left: 4px solid #4caf50;">' +
            '<strong style="display: block; margin-bottom: 8px; color: #2e7d32;">Recommended Action:</strong>' +
            '<p style="margin: 0; color: #1b5e20;">' + vuln.recommendation + '</p>' +
            '</div>';
        
        $('#unify-vuln-modal-content').html(content);
        $('#unify-vuln-modal').css('display', 'flex');
    });
    
    // Close modals
    $('#unify-close-modal, #unify-vuln-modal').on('click', function(e) {
        if (e.target === this) {
            $('#unify-vuln-modal').hide();
        }
    });
    
    // Manage Rules Modal
    $('#unify-manage-rules').on('click', function(e) {
        e.preventDefault();
        $('#unify-rules-modal').css('display', 'flex');
    });
    
    $('#unify-close-rules-modal, #unify-rules-modal').on('click', function(e) {
        if (e.target === this) {
            $('#unify-rules-modal').hide();
        }
    });
    
    // Add Rule
    $('#unify-add-rule').on('click', function(e) {
        e.preventDefault();
        $('#unify-rule-form-title').text('Add Vulnerability Rule');
        $('#unify-rule-form')[0].reset();
        $('#rule-id').val('');
        $('#unify-rule-form-modal').css('display', 'flex');
    });
    
    // Edit Rule
    $(document).on('click', '.unify-edit-rule', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        
        // For simplicity, we'll reload the page after edit
        // In a production app, you'd fetch the rule data via AJAX
        alert('Edit functionality: Reload page and fetch rule data via AJAX. For now, please delete and recreate.');
    });
    
    // Delete Rule
    $(document).on('click', '.unify-delete-rule', function(e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to delete this vulnerability rule?')) return;
        
        var id = $(this).data('id');
        var $row = $(this).closest('tr');
        
        $.post(ajaxurl, {
            action: 'unify_delete_manual_vulnerability',
            nonce: unify_vars.nonce,
            id: id
        }, function(response) {
            if (response.success) {
                $row.fadeOut(300, function() {
                    $(this).remove();
                    if ($('#unify-rules-table tbody tr').length === 0) {
                        location.reload();
                    }
                });
            } else {
                alert('Error: ' + (response.data.message || 'Failed to delete'));
            }
        });
    });
    
    // Close Rule Form Modal
    $('#unify-close-rule-form, #unify-cancel-rule-form, #unify-rule-form-modal').on('click', function(e) {
        if (e.target === this || $(this).is('#unify-cancel-rule-form') || $(this).is('#unify-close-rule-form')) {
            $('#unify-rule-form-modal').hide();
        }
    });
    
    // Submit Rule Form
    $('#unify-rule-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = {
            action: 'unify_save_manual_vulnerability',
            nonce: unify_vars.nonce,
            id: $('#rule-id').val(),
            target_type: $('#rule-target-type').val(),
            target_slug: $('#rule-target-slug').val(),
            severity: $('#rule-severity').val(),
            title: $('#rule-title').val(),
            description: $('#rule-description').val(),
            affected_versions: $('#rule-affected-versions').val().split(',').map(function(v) { return v.trim(); }).filter(Boolean),
            fixed_version: $('#rule-fixed-version').val(),
            cve_id: $('#rule-cve-id').val()
        };
        
        $.post(ajaxurl, formData, function(response) {
            if (response.success) {
                location.reload();
            } else {
                alert('Error: ' + (response.data.message || 'Failed to save'));
            }
        });
    });
});
</script>
    </div><!-- /.unify-blurred -->
</div><!-- /.unify-card -->
