<?php
/**
 * Consent Analytics Report View
 * 
 * @package Unify_Compliance
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_premium = unify_is_premium();
?>

<div class="unify-tabs">
    <a href="?page=unify-reports&tab=overview" class="unify-tab">Overview</a>
    <a href="?page=unify-reports&tab=consent" class="unify-tab active">Consent Analytics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
    <a href="?page=unify-reports&tab=security" class="unify-tab">Security Metrics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
</div>

<?php if ( ! $is_premium ): ?>
    <div class="unify-premium-only unify-locked">
        <div class="unify-locked-overlay">
            <span class="dashicons dashicons-lock unify-lock-icon"></span>
            <h3>Unlock Advanced Reporting</h3>
            <p>Get insights into consent rates, categories, and trends over time with interactive charts and custom date ranges.</p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=unify-settings&tab=license')); ?>" class="unify-btn unify-btn-primary">Activate License</a>
        </div>

        <!-- Static preview for free users -->
        <div class="unify-card unify-blurred">
            <div class="unify-card-header">
                <h2 class="unify-card-title">Consent Statistics</h2>
                <div style="display: flex; gap: 8px;">
                    <select style="padding: 6px; border-radius: 4px; border: 1px solid var(--unify-border);">
                        <option>Last 30 Days</option>
                        <option>Last 90 Days</option>
                    </select>
                    <button class="unify-btn unify-btn-secondary unify-btn-sm">Export PDF</button>
                </div>
            </div>

            <div class="unify-grid" style="grid-template-columns: 2fr 1fr; margin-bottom: 30px;">
                <!-- Fake Chart -->
                <div style="background: #f9fafb; height: 300px; display: flex; align-items: flex-end; padding: 20px; text-align: center; gap: 20px;">
                    <div style="flex: 1; height: 60%; background: #E0E7FF; border-radius: 4px 4px 0 0;"></div>
                    <div style="flex: 1; height: 75%; background: #E0E7FF; border-radius: 4px 4px 0 0;"></div>
                    <div style="flex: 1; height: 50%; background: #E0E7FF; border-radius: 4px 4px 0 0;"></div>
                    <div style="flex: 1; height: 80%; background: #4F46E5; border-radius: 4px 4px 0 0; position: relative;"><span style="position: absolute; top: -25px; left: 0; right: 0;">78%</span></div>
                    <div style="flex: 1; height: 70%; background: #E0E7FF; border-radius: 4px 4px 0 0;"></div>
                    <div style="flex: 1; height: 85%; background: #E0E7FF; border-radius: 4px 4px 0 0;"></div>
                </div>
                
                <div>
                    <h3 style="margin-top: 0;">Acceptance by Category</h3>
                    <div style="margin-bottom: 12px;">
                        <div style="display: flex; justify-content: space-between; font-size: 13px; margin-bottom: 4px;">
                            <span>Necessary</span> <span>100%</span>
                        </div>
                        <div style="height: 8px; background: #E5E7EB; border-radius: 4px;"><div style="width: 100%; background: #4F46E5; height: 100%; border-radius: 4px;"></div></div>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <div style="display: flex; justify-content: space-between; font-size: 13px; margin-bottom: 4px;">
                            <span>Functional</span> <span>85%</span>
                        </div>
                        <div style="height: 8px; background: #E5E7EB; border-radius: 4px;"><div style="width: 85%; background: #4F46E5; height: 100%; border-radius: 4px;"></div></div>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <div style="display: flex; justify-content: space-between; font-size: 13px; margin-bottom: 4px;">
                            <span>Analytics</span> <span>62%</span>
                        </div>
                        <div style="height: 8px; background: #E5E7EB; border-radius: 4px;"><div style="width: 62%; background: #4F46E5; height: 100%; border-radius: 4px;"></div></div>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <div style="display: flex; justify-content: space-between; font-size: 13px; margin-bottom: 4px;">
                            <span>Marketing</span> <span>34%</span>
                        </div>
                        <div style="height: 8px; background: #E5E7EB; border-radius: 4px;"><div style="width: 34%; background: #4F46E5; height: 100%; border-radius: 4px;"></div></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
<!-- Premium: Full functional reports -->
<div class="unify-card">
        <div class="unify-card-header">
            <h2 class="unify-card-title">Consent Statistics</h2>
            <div style="display: flex; gap: 8px;">
                <select id="unify-consent-date-range" style="padding: 6px; border-radius: 4px; border: 1px solid var(--unify-border);">
                    <option value="7">Last 7 Days</option>
                    <option value="30" selected>Last 30 Days</option>
                    <option value="90">Last 90 Days</option>
                    <option value="custom">Custom Range</option>
                </select>
                <button id="unify-export-consent-pdf" class="unify-btn unify-btn-secondary unify-btn-sm">
                    <span class="dashicons dashicons-download" style="font-size: 16px; width: 16px; height: 16px; margin-right: 4px;"></span>
                    Export PDF
                </button>
            </div>
        </div>

        <!-- Summary Stats -->
        <div class="unify-grid" style="grid-template-columns: repeat(3, 1fr); margin-bottom: 30px;">
            <div class="unify-stat-card">
                <div class="unify-stat-label">Total Consents</div>
                <div class="unify-stat-value" id="unify-total-consents">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Acceptance Rate</div>
                <div class="unify-stat-value" id="unify-acceptance-rate">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Period</div>
                <div class="unify-stat-value" id="unify-consent-period" style="font-size: 14px;">-</div>
            </div>
        </div>

        <div class="unify-grid" style="grid-template-columns: 2fr 1fr; margin-bottom: 30px;">
            <!-- Consent Trend Chart -->
            <div>
                <h3 style="margin-top: 0;">Consent Rate Over Time</h3>
                <canvas id="unify-consent-trend-chart" style="max-height: 300px;"></canvas>
            </div>
            
            <!-- Category Breakdown -->
            <div>
                <h3 style="margin-top: 0;">Acceptance by Category</h3>
                <div id="unify-category-breakdown">
                    <!-- Populated by JavaScript -->
                </div>
            </div>
        </div>

        <!-- DSAR Summary -->
        <div class="unify-card-header" style="margin-top: 30px;">
            <h3 class="unify-card-title">DSAR Requests Summary</h3>
        </div>
        <div class="unify-grid" style="grid-template-columns: repeat(4, 1fr); margin-bottom: 20px;">
            <div class="unify-stat-card">
                <div class="unify-stat-label">Total Requests</div>
                <div class="unify-stat-value" id="unify-dsar-total">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Access Requests</div>
                <div class="unify-stat-value" id="unify-dsar-access">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Delete Requests</div>
                <div class="unify-stat-value" id="unify-dsar-delete">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Avg Response Time</div>
                <div class="unify-stat-value" id="unify-dsar-avg-response">-</div>
            </div>
        </div>
    </div>

    <script>
    jQuery(document).ready(function($) {
        let consentChart = null;
        
        // Load consent data
        function loadConsentData() {
            const range = $('#unify-consent-date-range').val();
            let startDate, endDate = new Date().toISOString().split('T')[0];
            
            if (range === 'custom') {
                // TODO: Implement custom date picker
                return;
            }
            
            const daysAgo = parseInt(range);
            startDate = new Date();
            startDate.setDate(startDate.getDate() - daysAgo);
            startDate = startDate.toISOString().split('T')[0];
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'unify_get_consent_stats',
                    nonce: unify_vars.reports_nonce,
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    if (response.success) {
                        updateConsentUI(response.data);
                    } else {
                        console.error('Error loading consent stats:', response.data.message);
                    }
                },
                error: function() {
                    console.error('AJAX error loading consent stats');
                }
            });
            
            // Load DSAR stats
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'unify_get_dsar_stats',
                    nonce: unify_vars.reports_nonce,
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    if (response.success) {
                        updateDSARUI(response.data);
                    }
                }
            });
        }
        
        function updateConsentUI(data) {
            // Update summary stats
            $('#unify-total-consents').text(data.total_consents.toLocaleString());
            $('#unify-acceptance-rate').text(data.acceptance_rate + '%');
            $('#unify-consent-period').text(data.period.start + ' to ' + data.period.end);
            
            // Update category breakdown
            const categories = data.category_percentages;
            let html = '';
            for (const [key, value] of Object.entries(categories)) {
                const label = key.charAt(0).toUpperCase() + key.slice(1);
                html += `
                    <div style="margin-bottom: 12px;">
                        <div style="display: flex; justify-content: space-between; font-size: 13px; margin-bottom: 4px;">
                            <span>${label}</span> <span>${value}%</span>
                        </div>
                        <div style="height: 8px; background: #E5E7EB; border-radius: 4px;">
                            <div style="width: ${value}%; background: #4F46E5; height: 100%; border-radius: 4px;"></div>
                        </div>
                    </div>
                `;
            }
            $('#unify-category-breakdown').html(html);
            
            // Update chart
            updateConsentChart(data.daily_stats);
        }
        
        function updateConsentChart(dailyStats) {
            const ctx = document.getElementById('unify-consent-trend-chart');
            
            if (consentChart) {
                consentChart.destroy();
            }
            
            const labels = dailyStats.map(d => d.date);
            const data = dailyStats.map(d => parseInt(d.total_consents));
            
            consentChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Total Consents',
                        data: data,
                        borderColor: '#4F46E5',
                        backgroundColor: 'rgba(79, 70, 229, 0.1)',
                        tension: 0.4,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
        }
        
        function updateDSARUI(data) {
            $('#unify-dsar-total').text(data.total_requests);
            
            // Count by type
            let accessCount = 0, deleteCount = 0;
            data.by_type.forEach(item => {
                if (item.request_type === 'access') accessCount = parseInt(item.count);
                if (item.request_type === 'delete') deleteCount = parseInt(item.count);
            });
            
            $('#unify-dsar-access').text(accessCount);
            $('#unify-dsar-delete').text(deleteCount);
            $('#unify-dsar-avg-response').text(data.avg_response_days + ' days');
        }
        
        // Event handlers
        $('#unify-consent-date-range').on('change', loadConsentData);
        
        $('#unify-export-consent-pdf').on('click', function() {
            alert('PDF export functionality coming soon!');
        });
        
        // Initial load
        loadConsentData();
    });
    </script>

    <style>
    .unify-stat-card {
        background: #f9fafb;
        padding: 16px;
        border-radius: 8px;
        border: 1px solid var(--unify-border);
    }
    .unify-stat-label {
        font-size: 12px;
        color: var(--unify-text-secondary);
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .unify-stat-value {
        font-size: 24px;
        font-weight: 600;
        color: var(--unify-text-primary);
    }
    .unify-blurred {
        filter: blur(3px);
        pointer-events: none;
        user-select: none;
    }
    </style>
<?php endif; ?>
