<?php
/**
 * Reports Overview View (Free Tier)
 * 
 * @package Unify_Compliance
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_premium = unify_is_premium();
?>

<div class="unify-tabs">
    <a href="?page=unify-reports&tab=overview" class="unify-tab active">Overview</a>
    <a href="?page=unify-reports&tab=consent" class="unify-tab">Consent Analytics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
    <a href="?page=unify-reports&tab=security" class="unify-tab">Security Metrics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
</div>

<div class="unify-card">
    <div class="unify-card-header">
        <h2 class="unify-card-title">Reports Overview</h2>
        <div style="font-size: 13px; color: var(--unify-text-secondary);">
            Last 30 Days Snapshot
        </div>
    </div>

    <div class="unify-grid" style="grid-template-columns: repeat(3, 1fr); margin-bottom: 20px;">
        <!-- Consent Stats -->
        <div class="unify-stat-card">
            <div class="unify-stat-label">Total Consents</div>
            <div class="unify-stat-value" id="unify-overview-consent-total">-</div>
            <div style="margin-top: 8px; font-size: 13px;">
                Acceptance Rate: <strong id="unify-overview-acceptance">-</strong>
            </div>
            <a href="?page=unify-reports&tab=consent" class="unify-btn unify-btn-secondary unify-btn-sm" style="margin-top: 12px; width: 100%; justify-content: center;">
                View Analytics
            </a>
        </div>

        <!-- Security Stats -->
        <div class="unify-stat-card">
            <div class="unify-stat-label">Security Score</div>
            <div class="unify-stat-value" id="unify-overview-security-score">-</div>
            <div style="margin-top: 8px; font-size: 13px;">
                Failed Logins: <strong id="unify-overview-failed-logins">-</strong>
            </div>
            <a href="?page=unify-reports&tab=security" class="unify-btn unify-btn-secondary unify-btn-sm" style="margin-top: 12px; width: 100%; justify-content: center;">
                View Metrics
            </a>
        </div>

        <!-- DSAR Stats -->
        <div class="unify-stat-card">
            <div class="unify-stat-label">DSAR Requests</div>
            <div class="unify-stat-value" id="unify-overview-dsar-total">-</div>
            <div style="margin-top: 8px; font-size: 13px;">
                Pending Action: <strong>0</strong>
            </div>
            <a href="?page=unify-gdpr&tab=queue" class="unify-btn unify-btn-secondary unify-btn-sm" style="margin-top: 12px; width: 100%; justify-content: center;">
                Manage Queue
            </a>
        </div>
    </div>

    <?php if ( ! $is_premium ): ?>
    <div class="unify-notice unify-notice-info" style="display: flex; align-items: center; justify-content: space-between;">
        <div style="display: flex; align-items: center; gap: 12px;">
            <span class="dashicons dashicons-chart-area" style="font-size: 24px; width: 24px; height: 24px; color: var(--unify-primary);"></span>
            <div>
                <strong>Unlock Advanced Reporting</strong>
                <p style="margin: 4px 0 0 0; font-size: 13px;">Upgrade to Premium to access detailed interactive charts, custom date ranges, and PDF exports.</p>
            </div>
        </div>
        <a href="<?php echo esc_url(admin_url('admin.php?page=unify-settings&tab=license')); ?>" class="unify-btn unify-btn-primary">Upgrade Now</a>
    </div>
    <?php endif; ?>
</div>

<script>
jQuery(document).ready(function($) {
    // Load overview data
    $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
            action: 'unify_get_overview_stats',
            nonce: unify_vars.reports_nonce
        },
        success: function(response) {
            if (response.success) {
                const data = response.data;
                
                // Consent
                $('#unify-overview-consent-total').text(data.consent.total.toLocaleString());
                $('#unify-overview-acceptance').text(data.consent.acceptance_rate + '%');
                
                // Security
                $('#unify-overview-security-score').text(data.security.score + '/100');
                if (data.security.score >= 80) $('#unify-overview-security-score').css('color', '#10B981');
                else if (data.security.score >= 60) $('#unify-overview-security-score').css('color', '#F59E0B');
                else $('#unify-overview-security-score').css('color', '#EF4444');
                
                $('#unify-overview-failed-logins').text(data.security.failed_logins.toLocaleString());
                
                // DSAR
                $('#unify-overview-dsar-total').text(data.dsar.total.toLocaleString());
            }
        }
    });
});
</script>

<style>
.unify-stat-card {
    background: #f9fafb;
    padding: 20px;
    border-radius: 8px;
    border: 1px solid var(--unify-border);
}
.unify-stat-label {
    font-size: 12px;
    color: var(--unify-text-secondary);
    margin-bottom: 8px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}
.unify-stat-value {
    font-size: 32px;
    font-weight: 600;
    color: var(--unify-text-primary);
}
</style>
