<?php
/**
 * Security Metrics Report View
 * 
 * @package Unify_Compliance
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$is_premium = unify_is_premium();
?>

<div class="unify-tabs">
    <a href="?page=unify-reports&tab=overview" class="unify-tab">Overview</a>
    <a href="?page=unify-reports&tab=consent" class="unify-tab">Consent Analytics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
    <a href="?page=unify-reports&tab=security" class="unify-tab active">Security Metrics<?php if(!$is_premium) echo ' <span class="dashicons dashicons-lock" style="font-size: 14px; width: 14px; height: 14px;"></span>'; ?></a>
</div>

<?php if ( ! $is_premium ): ?>
    <div class="unify-premium-only unify-locked">
        <div class="unify-locked-overlay">
            <span class="dashicons dashicons-lock unify-lock-icon"></span>
            <h3>Unlock Security Metrics</h3>
            <p>Visualize your security posture with NIS2 activity charts and custom date ranges.</p>
            <a href="<?php echo esc_url(admin_url('admin.php?page=unify-settings&tab=license')); ?>" class="unify-btn unify-btn-primary">Activate License</a>
        </div>

        <!-- Static preview for free users -->
        <div class="unify-grid unify-blurred" style="grid-template-columns: 1fr 1fr;">
            <div class="unify-card">
                <div class="unify-card-header">
                    <h3 class="unify-card-title">Failed Login Attempts</h3>
                    <span class="unify-badge unify-badge-error">High Activity</span>
                </div>
                <div style="background: #f9fafb; height: 200px; display: flex; align-items: flex-end; padding: 10px; gap: 10px;">
                    <div style="flex: 1; height: 10%; background: #FECACA; border-radius: 2px;"></div>
                    <div style="flex: 1; height: 20%; background: #FECACA; border-radius: 2px;"></div>
                    <div style="flex: 1; height: 80%; background: #EF4444; border-radius: 2px;"></div>
                    <div style="flex: 1; height: 30%; background: #FECACA; border-radius: 2px;"></div>
                    <div style="flex: 1; height: 15%; background: #FECACA; border-radius: 2px;"></div>
                </div>
                <p style="text-align: center; color: var(--unify-text-secondary); margin-top: 10px; font-size: 13px;">Past 7 Days</p>
            </div>
            
            <div class="unify-card">
                <div class="unify-card-header">
                    <h3 class="unify-card-title">Top Suspicious IPs</h3>
                </div>
                <table class="unify-table">
                    <thead>
                        <tr>
                            <th>IP Address</th>
                            <th>Attempts</th>
                            <th>Last Seen</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>45.33.22.11</td>
                            <td>34</td>
                            <td>2 mins ago</td>
                        </tr>
                        <tr>
                            <td>192.168.99.1</td>
                            <td>12</td>
                            <td>1 hour ago</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php else: ?>
<!-- Premium: Full functional reports -->
<div class="unify-card">
        <div class="unify-card-header">
            <h2 class="unify-card-title">Security Metrics</h2>
            <div style="display: flex; gap: 8px;">
                <select id="unify-security-date-range" style="padding: 6px; border-radius: 4px; border: 1px solid var(--unify-border);">
                    <option value="7">Last 7 Days</option>
                    <option value="30" selected>Last 30 Days</option>
                    <option value="90">Last 90 Days</option>
                </select>
                <button id="unify-export-security-pdf" class="unify-btn unify-btn-secondary unify-btn-sm">
                    <span class="dashicons dashicons-download" style="font-size: 16px; width: 16px; height: 16px; margin-right: 4px;"></span>
                    Export PDF
                </button>
            </div>
        </div>

        <!-- Summary Stats -->
        <div class="unify-grid" style="grid-template-columns: repeat(4, 1fr); margin-bottom: 30px;">
            <div class="unify-stat-card">
                <div class="unify-stat-label">Security Score</div>
                <div class="unify-stat-value" id="unify-security-score" style="color: #10B981;">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Successful Logins</div>
                <div class="unify-stat-value" id="unify-successful-logins">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Failed Logins</div>
                <div class="unify-stat-value" id="unify-failed-logins" style="color: #EF4444;">-</div>
            </div>
            <div class="unify-stat-card">
                <div class="unify-stat-label">Plugin Updates</div>
                <div class="unify-stat-value" id="unify-plugin-updates">-</div>
            </div>
        </div>

        <div class="unify-grid" style="grid-template-columns: 1fr 1fr; margin-bottom: 30px;">
            <!-- Failed Login Chart -->
            <div class="unify-card">
                <div class="unify-card-header">
                    <h3 class="unify-card-title">Failed Login Attempts</h3>
                    <span class="unify-badge" id="unify-login-badge">Normal</span>
                </div>
                <canvas id="unify-failed-logins-chart" style="max-height: 250px;"></canvas>
            </div>
            
            <!-- Suspicious IPs -->
            <div class="unify-card">
                <div class="unify-card-header">
                    <h3 class="unify-card-title">Top Suspicious IPs</h3>
                </div>
                <div id="unify-suspicious-ips-container" style="max-height: 250px; overflow-y: auto;">
                    <!-- Populated by JavaScript -->
                </div>
            </div>
        </div>

        <!-- Plugin Updates -->
        <div class="unify-card">
            <div class="unify-card-header">
                <h3 class="unify-card-title">Recent Plugin Updates</h3>
            </div>
            <div id="unify-plugin-updates-container">
                <!-- Populated by JavaScript -->
            </div>
        </div>
    </div>

    <script>
    jQuery(document).ready(function($) {
        let failedLoginsChart = null;
        
        // Load security data
        function loadSecurityData() {
            const range = $('#unify-security-date-range').val();
            let startDate, endDate = new Date().toISOString().split('T')[0];
            
            const daysAgo = parseInt(range);
            startDate = new Date();
            startDate.setDate(startDate.getDate() - daysAgo);
            startDate = startDate.toISOString().split('T')[0];
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'unify_get_security_stats',
                    nonce: unify_vars.reports_nonce,
                    start_date: startDate,
                    end_date: endDate
                },
                success: function(response) {
                    if (response.success) {
                        updateSecurityUI(response.data);
                    } else {
                        console.error('Error loading security stats:', response.data.message);
                    }
                },
                error: function() {
                    console.error('AJAX error loading security stats');
                }
            });
        }
        
        function updateSecurityUI(data) {
            // Update summary stats
            const score = data.security_score;
            $('#unify-security-score').text(score + '/100');
            
            // Color code security score
            if (score >= 80) {
                $('#unify-security-score').css('color', '#10B981'); // Green
            } else if (score >= 60) {
                $('#unify-security-score').css('color', '#F59E0B'); // Orange
            } else {
                $('#unify-security-score').css('color', '#EF4444'); // Red
            }
            
            $('#unify-successful-logins').text(data.successful_logins.toLocaleString());
            $('#unify-failed-logins').text(data.failed_logins.toLocaleString());
            $('#unify-plugin-updates').text(data.plugin_updates.length);
            
            // Update login badge
            const failedRatio = data.failed_logins / (data.successful_logins + data.failed_logins);
            if (failedRatio > 0.3) {
                $('#unify-login-badge').removeClass('unify-badge-success').addClass('unify-badge-error').text('High Activity');
            } else if (failedRatio > 0.1) {
                $('#unify-login-badge').removeClass('unify-badge-success unify-badge-error').addClass('unify-badge-warning').text('Moderate');
            } else {
                $('#unify-login-badge').removeClass('unify-badge-error unify-badge-warning').addClass('unify-badge-success').text('Normal');
            }
            
            // Update failed logins chart
            updateFailedLoginsChart(data.failed_logins_daily);
            
            // Update suspicious IPs table
            updateSuspiciousIPs(data.suspicious_ips);
            
            // Update plugin updates list
            updatePluginUpdates(data.plugin_updates);
        }
        
        function updateFailedLoginsChart(dailyStats) {
            const ctx = document.getElementById('unify-failed-logins-chart');
            
            if (failedLoginsChart) {
                failedLoginsChart.destroy();
            }
            
            const labels = dailyStats.map(d => d.date);
            const data = dailyStats.map(d => parseInt(d.failed_attempts));
            
            failedLoginsChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'Failed Attempts',
                        data: data,
                        backgroundColor: '#EF4444',
                        borderRadius: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            ticks: {
                                precision: 0
                            }
                        }
                    }
                }
            });
        }
        
        function updateSuspiciousIPs(ips) {
            if (ips.length === 0) {
                $('#unify-suspicious-ips-container').html('<p style="text-align: center; color: var(--unify-text-secondary); padding: 20px;">No suspicious activity detected</p>');
                return;
            }
            
            let html = '<table class="unify-table"><thead><tr><th>IP Address</th><th>Attempts</th><th>Last Seen</th></tr></thead><tbody>';
            ips.forEach(ip => {
                const lastSeen = new Date(ip.last_seen).toLocaleString();
                html += `<tr><td>${ip.ip_address}</td><td><span class="unify-badge unify-badge-error">${ip.attempts}</span></td><td>${lastSeen}</td></tr>`;
            });
            html += '</tbody></table>';
            $('#unify-suspicious-ips-container').html(html);
        }
        
        function updatePluginUpdates(updates) {
            if (updates.length === 0) {
                $('#unify-plugin-updates-container').html('<p style="text-align: center; color: var(--unify-text-secondary); padding: 20px;">No plugin updates in this period</p>');
                return;
            }
            
            let html = '<table class="unify-table"><thead><tr><th>Plugin</th><th>Date</th><th>User</th></tr></thead><tbody>';
            updates.slice(0, 10).forEach(update => {
                const date = new Date(update.event_date).toLocaleString();
                const details = update.event_details || 'Plugin updated';
                html += `<tr><td>${details}</td><td>${date}</td><td>User ID: ${update.user_id}</td></tr>`;
            });
            html += '</tbody></table>';
            $('#unify-plugin-updates-container').html(html);
        }
        
        // Event handlers
        $('#unify-security-date-range').on('change', loadSecurityData);
        
        $('#unify-export-security-pdf').on('click', function() {
            alert('PDF export functionality coming soon!');
        });
        
        // Initial load
        loadSecurityData();
    });
    </script>

    <style>
    .unify-stat-card {
        background: #f9fafb;
        padding: 16px;
        border-radius: 8px;
        border: 1px solid var(--unify-border);
    }
    .unify-stat-label {
        font-size: 12px;
        color: var(--unify-text-secondary);
        margin-bottom: 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    .unify-stat-value {
        font-size: 24px;
        font-weight: 600;
        color: var(--unify-text-primary);
    }
    .unify-blurred {
        filter: blur(3px);
        pointer-events: none;
        user-select: none;
    }
    </style>
<?php endif; ?>
