<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$is_premium = unify_is_premium();
?>
<div class="unify-tabs">
    <a href="?page=unify-settings&tab=license" class="unify-tab">License</a>
    <a href="?page=unify-settings&tab=jurisdictions" class="unify-tab active <?php echo $is_premium ? '' : 'locked'; ?>">
        <?php if ( ! $is_premium ) : ?>
            <span class="dashicons dashicons-lock"></span>
        <?php endif; ?>
        Jurisdictions
    </a>
</div>

<div class="unify-premium-only <?php echo $is_premium ? '' : 'locked'; ?>">
    <?php if ( ! $is_premium ) : ?>
    <div class="unify-locked-overlay">
        <span class="dashicons dashicons-lock unify-lock-icon"></span>
        <h3>Unlock Multi-Jurisdiction Rules</h3>
        <p>Display different compliance banners based entirely on user's location.</p>
        <a href="?page=unify-settings&tab=license" class="unify-btn unify-btn-primary">Activate License</a>
    </div>
    <?php endif; ?>

    <div class="unify-card">
        <div class="unify-card-header">
            <h2 class="unify-card-title">Geo-Targeting Rules</h2>
            <button class="unify-btn unify-btn-primary">Add Rule</button>
        </div>
        
        <div style="margin-bottom: 24px;">
            <p><strong>Geolocation:</strong> Cloudflare Headers <span class="dashicons dashicons-yes" style="color: var(--unify-success);"></span></p>
        </div>

        <table class="unify-table">
            <thead>
                <tr>
                    <th>Region</th>
                    <th>Countries included</th>
                    <th>Action</th>
                    <th>Priority</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php
                $rules = Unify_Jurisdiction_Manager::get_rules();
                foreach ( $rules as $rule ) :
                    $region_label = $rule['region_type'];
                    if ($rule['region_type'] === 'preset_eu') $region_label = 'European Union (Preset)';
                    elseif ($rule['region_type'] === 'global') $region_label = 'Global (Default)';
                    elseif ($rule['region_type'] === 'countries') $region_label = 'Custom Selection';
                    
                    $countries_html = '-';
                    if (!empty($rule['countries'])) {
                        $count = count($rule['countries']);
                        if ($count > 3) {
                            $countries_html = implode(', ', array_slice($rule['countries'], 0, 3)) . '... (' . $count . ')';
                        } else {
                            $countries_html = implode(', ', $rule['countries']);
                        }
                    } elseif ($rule['region_type'] === 'preset_eu') {
                         $countries_html = 'EU + EEA + UK';
                    } elseif ($rule['region_type'] === 'global') {
                        $countries_html = 'All others';
                    }
                ?>
                <tr>
                    <td><strong><?php echo esc_html($region_label); ?></strong></td>
                    <td><?php echo esc_html($countries_html); ?></td>
                    <td><?php echo esc_html(ucfirst($rule['action'])); ?></td>
                    <td><?php echo intval($rule['priority']); ?></td>
                    <td>
                        <?php if ($rule['id'] !== 'default') : ?>
                            <button class="unify-btn unify-btn-secondary unify-btn-sm" onclick="editRule('<?php echo esc_attr($rule['id']); ?>')">Edit</button>
                            <button class="unify-btn unify-btn-danger unify-btn-sm" onclick="deleteRule('<?php echo esc_attr($rule['id']); ?>')">Delete</button>
                        <?php else: ?>
                            <span class="unify-badge">Locked</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div style="margin-top: 24px; padding-top: 24px; border-top: 1px solid var(--unify-border);">
            <h3>Test Geolocation</h3>
            <p style="margin-bottom: 15px; color: var(--unify-text-secondary); font-size: 13px;">
                Simulate a visitor from a specific country to test your rules. 
                <br>Currently simulated: <strong><?php echo esc_html(isset($_COOKIE['unify_simulate_country']) ? $_COOKIE['unify_simulate_country'] : 'None (Real IP)'); ?></strong>
            </p>
            <div style="display: flex; gap: 12px; align-items: center;">
                <p style="margin: 0;">Simulate as:</p>
                <button class="unify-btn unify-btn-secondary unify-btn-sm unify-simulate-btn" data-country="DE">Germany (EU)</button>
                <button class="unify-btn unify-btn-secondary unify-btn-sm unify-simulate-btn" data-country="US">USA</button>
                <button class="unify-btn unify-btn-secondary unify-btn-sm unify-simulate-btn" data-country="BR">Brazil</button>
                <button class="unify-btn unify-btn-secondary unify-btn-sm unify-simulate-btn" data-country="">Reset (Clear)</button>
            </div>
        </div>
    </div>
</div>
