<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$license_status = Unify_License::get_status();
$is_active      = $license_status['active'];
?>
<div class="unify-tabs">
    <a href="?page=unify-settings&tab=license" class="unify-tab active">License</a>
</div>

<div class="unify-grid" style="grid-template-columns: 2fr 1fr;">
    <div class="unify-card">
        <div class="unify-card-header">
            <h2 class="unify-card-title">License Management</h2>
        </div>

        <!-- License Activation Form (Show if NOT active) -->
        <div id="unify-license-form" style="<?php echo $is_active ? 'display: none;' : ''; ?> padding: 20px; text-align: center; border: 2px dashed var(--unify-border); border-radius: 8px; margin-bottom: 24px;">
            <p style="margin-bottom: 20px;">Enter your license key to unlock Premium features.</p>
            <div style="max-width: 400px; margin: 0 auto;">
                <input type="text" id="unify-license-key" placeholder="Paste your license key here..." style="width: 100%; padding: 10px; margin-bottom: 10px; border: 1px solid var(--unify-border); border-radius: 4px;">
                <button id="unify-btn-activate" class="unify-btn unify-btn-primary" style="width: 100%;">
                    <span class="unify-btn-text">Activate License</span>
                    <span class="unify-spinner dashicons dashicons-update-alt" style="display:none; animation: spin 1s linear infinite;"></span>
                </button>
            </div>
            <p id="unify-license-message" style="color: #ef4444; font-size: 13px; margin-top: 12px; display: none;"></p>
            <p style="font-size: 13px; margin-top: 12px;"><a href="#">Where do I find my license key?</a></p>
        </div>
        
        <!-- Active License Info (Show if active) -->
        <div id="unify-license-active" style="<?php echo $is_active ? '' : 'display: none;'; ?>">
             <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 24px; background: #ECFDF5; padding: 16px; border-radius: 8px; border: 1px solid #10B981;">
                 <span class="dashicons dashicons-yes" style="color: #10B981; font-size: 24px;"></span>
                 <div>
                     <strong>Premium License Active</strong><br>
                     <span style="font-size: 13px; color: #047857;">License Key: <code style="background: rgba(255,255,255,0.5); padding: 2px 4px; border-radius: 3px;"><?php echo esc_html( $license_status['key_masked'] ); ?></code></span>
                 </div>
                 <button id="unify-btn-deactivate" class="unify-btn unify-btn-secondary unify-btn-sm" style="margin-left: auto;">
                    <span class="unify-btn-text">Deactivate</span>
                    <span class="unify-spinner dashicons dashicons-update-alt" style="display:none; animation: spin 1s linear infinite;"></span>
                 </button>
             </div>
        </div>

        <h3 style="margin-bottom: 16px;">General Settings</h3>
        <form class="unify-ajax-form">
            <input type="hidden" name="action" value="unify_save_general_settings">
            <?php wp_nonce_field('unify_admin_nonce', 'nonce'); ?>
            
            <div class="unify-status-item" style="margin-bottom: 16px;">
                <label style="display: flex; align-items: center; gap: 8px;">
                    <input type="checkbox" name="unify_remove_on_uninstall" value="1" <?php checked(Unify_Settings::get_option('unify_remove_on_uninstall')); ?>> 
                    Remove data on uninstall
                </label>
            </div>
            
            <button type="submit" class="unify-btn unify-btn-primary">Save Settings</button>
        </form>
    </div>
    
    <!-- Plan Comparison -->
    <div class="unify-card">
        <h3 style="margin-top: 0;">Plan Comparison</h3>
        <ul style="list-style: none; padding: 0;">
            <li style="padding: 8px 0; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between;">
                <span>GDPR & NIS2</span> <span class="dashicons dashicons-yes" style="color: var(--unify-success);"></span>
            </li>
             <li style="padding: 8px 0; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between;">
                <span>Cookie Scanner</span> 
                <?php if ( $is_active ) : ?>
                    <span class="dashicons dashicons-yes" style="color: var(--unify-success);"></span>
                <?php else : ?>
                    <span class="dashicons dashicons-no-alt" style="color: var(--unify-text-secondary); opacity: 0.5;"></span>
                <?php endif; ?>
            </li>
             <li style="padding: 8px 0; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between;">
                <span>Auto-DSAR</span>
                <?php if ( $is_active ) : ?>
                    <span class="dashicons dashicons-yes" style="color: var(--unify-success);"></span>
                <?php else : ?>
                    <span class="dashicons dashicons-no-alt" style="color: var(--unify-text-secondary); opacity: 0.5;"></span>
                <?php endif; ?>
            </li>
             <li style="padding: 8px 0; display: flex; justify-content: space-between;">
                <span>AI Act Toolset</span> <span class="unify-badge unify-badge-premium">Pro</span>
            </li>
        </ul>
        <?php if ( ! $is_active ) : ?>
            <a href="#" class="unify-btn unify-btn-primary" style="width: 100%; text-align: center; justify-content: center;">View All Plans</a>
        <?php endif; ?>
    </div>
</div>
