<?php
// includes/ai-act/class-unify-ai-detector.php

defined('ABSPATH') || exit;

class Unify_AI_Detector {
    
    private static $known_ai_plugins = [
        // AI-specific plugins
        'ai-engine' => 'AI Engine (Jordy Meow)',
        'chatgpt-plugin' => 'ChatGPT Plugin',
        'ai-content-writer' => 'AI Content Writer',
        'openai-embeddings' => 'OpenAI Embeddings',
        'bertha-ai' => 'Bertha AI',
        'ai-power' => 'AI Power - Complete AI Pack',
        'gpt3-ai-content-generator' => 'GPT-3 AI Content Generator',
        'writesonic' => 'Writesonic - AI Writer',
        'copy-ai' => 'Copy.ai Plugin',
        'wordlift' => 'WordLift (AI-powered SEO)',
        
        // Popular plugins with AI features
        'jetpack' => 'Jetpack AI Assistant',
        'rank-math' => 'Rank Math (AI Content Assistant)',
        'yoast-seo' => 'Yoast SEO (AI features)',
        'elementor' => 'Elementor (AI Builder)',
        'wpforms' => 'WPForms (AI Form Builder)',
        'all-in-one-seo-pack' => 'AIOSEO (AI Tools)',
        
        // WooCommerce AI
        'woocommerce-ai' => 'WooCommerce AI',
        'product-recommendations-ai' => 'AI Product Recommendations',
        
        // Security/Spam AI
        'akismet' => 'Akismet (AI Spam Detection)',
        'wordfence' => 'Wordfence (AI Security)',
        
        // Chatbot plugins
        'tidio-live-chat' => 'Tidio Live Chat (AI Chatbot)',
        'wp-chatbot' => 'WP Chatbot',
        'chatbot' => 'ChatBot for WordPress',
        'collect-chat' => 'Collect.chat (AI Chatbot)',
        
        // Content & Translation
        'weglot' => 'Weglot (AI Translation)',
        'translatepress' => 'TranslatePress (AI Translation)',
        'polylang' => 'Polylang (AI Translation features)'
    ];

    
    public static function scan() {
        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        
        $all_plugins = get_plugins();
        $detected = [];
        
        foreach ($all_plugins as $path => $data) {
            $slug = dirname($path);
            if ($slug === '.') $slug = basename($path, '.php');
            
            if (array_key_exists($slug, self::$known_ai_plugins)) {
                $detected[] = [
                    'slug' => $slug,
                    'name' => $data['Name'],
                    'known_as' => self::$known_ai_plugins[$slug]
                ];
            }
        }
        
        return $detected;
    }
    
    public static function suggest_registration($plugin_slug) {
        $name = isset(self::$known_ai_plugins[$plugin_slug]) ? self::$known_ai_plugins[$plugin_slug] : 'Unknown AI Plugin';
        return [
            'system_name' => $name,
            'provider' => 'Third-party Plugin',
            'purpose' => 'Content Generation / Chatbot',
            'risk_level' => 'limited' // Default assumption
        ];
    }
}
