<?php
// includes/ai-act/class-unify-ai-registry.php

defined('ABSPATH') || exit;

class Unify_AI_Registry {
    
    public static function init() {
        // Hooks for future use if needed (e.g., custom actions on add/delete)
    }

    public static function add_system($data) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_systems';
        
        $defaults = [
            'system_name' => '',
            'provider' => '',
            'purpose' => '',
            'risk_level' => 'minimal',
            'data_types' => '',
            'decision_impact' => '',
            'human_oversight' => 0,
            'created_date' => current_time('mysql'),
            'last_review' => current_time('mysql')
        ];
        
        $data = wp_parse_args($data, $defaults);
        
        // Sanitize data
        $insert_data = [
            'system_name' => sanitize_text_field($data['system_name']),
            'provider' => sanitize_text_field($data['provider']),
            'purpose' => sanitize_textarea_field($data['purpose']),
            'risk_level' => sanitize_text_field($data['risk_level']),
            'data_types' => (isset($data['data_types']) && is_array($data['data_types'])) 
                ? json_encode($data['data_types']) 
                : (isset($data['data_types']) ? sanitize_text_field($data['data_types']) : ''),
            'decision_impact' => sanitize_textarea_field($data['decision_impact']),
            'human_oversight' => intval($data['human_oversight']),
            'created_date' => $data['created_date'],
            'last_review' => $data['last_review']
        ];

        if (isset($data['disclosure_page_id'])) {
            $insert_data['disclosure_page_id'] = intval($data['disclosure_page_id']);
        }
        
        $format = ['%s', '%s', '%s', '%s', '%s', '%s', '%d', '%s', '%s'];
        if (isset($insert_data['disclosure_page_id'])) $format[] = '%d';

        $result = $wpdb->insert($table, $insert_data, $format);
        
        return $result ? $wpdb->insert_id : false;
    }

    public static function update_system($id, $data) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_systems';
        
        $data['last_review'] = current_time('mysql');
        
        // We only update fields that are present in $data
        $update_data = [];
        $format = [];

        $fields = ['system_name' => '%s', 'provider' => '%s', 'purpose' => '%s', 'risk_level' => '%s', 'data_types' => '%s', 'decision_impact' => '%s', 'human_oversight' => '%d', 'disclosure_page_id' => '%d', 'last_review' => '%s'];
        
        foreach ($fields as $field => $fmt) {
            if (isset($data[$field])) {
                if ($field === 'data_types') {
                     // Assuming passed as JSON string or array needing encoding? 
                     // For now assume string as per DB schema TEXT, but callers should encode.
                     // A safer bet is to maybe handle array here if passed.
                     if (is_array($data[$field])) {
                         $update_data[$field] = json_encode($data[$field]);
                     } else {
                         $update_data[$field] = sanitize_text_field($data[$field]);
                     }
                } else {
                     $update_data[$field] = $data[$field]; // Should be sanitized
                }
                $format[] = $fmt;
            }
        }
        
        if (empty($update_data)) return false;

        return $wpdb->update($table, $update_data, ['id' => $id], $format, ['%d']);
    }

    public static function delete_system($id) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_systems';
        return $wpdb->delete($table, ['id' => $id], ['%d']);
    }

    public static function get_system($id) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_systems';
        return $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $id));
    }

    public static function get_all_systems() {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_systems';
        return $wpdb->get_results("SELECT * FROM $table ORDER BY created_date DESC");
    }
}
