<?php
// includes/ai-act/class-unify-transparency-card.php

defined('ABSPATH') || exit;

class Unify_Transparency_Card {
    
    public static function init() {
        add_shortcode('unify_ai_disclosure', [__CLASS__, 'render_shortcode']);
    }

    public static function render_shortcode($atts) {
        $atts = shortcode_atts(['system_id' => 0], $atts);
        if (empty($atts['system_id'])) return '';
        
        return self::generate_card($atts['system_id']);
    }

    public static function generate_card($system_id) {
        if (!class_exists('Unify_AI_Registry')) return '';
        
        $system = Unify_AI_Registry::get_system($system_id);
        if (!$system) return '<p>AI System not found.</p>';
        
        $risk_class = 'unify-risk-' . esc_attr($system->risk_level);
        $risk_label = ucwords(str_replace('_', ' ', $system->risk_level));
        
        // Basic template - can be moved to a view file later for better separation
        $html = '<div class="unify-transparency-card ' . $risk_class . '">';
        $html .= '<h3>' . esc_html($system->system_name) . '</h3>';
        $html .= '<div class="unify-ai-detail"><span class="unify-label">Provider:</span> ' . esc_html($system->provider) . '</div>';
        $html .= '<div class="unify-ai-detail"><span class="unify-label">Risk Level:</span> <span class="unify-badge">' . esc_html($risk_label) . '</span></div>';
        $html .= '<div class="unify-ai-section"><h4>Purpose</h4><p>' . wp_kses_post($system->purpose) . '</p></div>';
        
        if (!empty($system->data_types)) {
            // Check if JSON
            $data_types = json_decode($system->data_types);
            if (json_last_error() === JSON_ERROR_NONE && is_array($data_types)) {
                 $data_list = implode(', ', array_map('esc_html', $data_types));
            } else {
                 $data_list = esc_html($system->data_types);
            }
            $html .= '<div class="unify-ai-section"><h4>Data Processed</h4><p>' . $data_list . '</p></div>';
        }

        if ($system->human_oversight) {
            $html .= '<div class="unify-ai-footer"><span class="unify-icon-check">✓</span> Human Oversight mechanisms in place.</div>';
        }
        
        $html .= '</div>';
        
        // Save disclosure record
        self::log_disclosure($system_id, $html);
        
        return $html;
    }
    
    private static function log_disclosure($system_id, $content) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_ai_disclosures';
        
        // Simple check to avoid spamming logs on every page load? 
        // For now, let's just insert/update a "latest generated" record or just insert.
        // PRD says "generated date", implies tracking history. But on every page load might be too much.
        // Maybe only log when generated via Admin? 
        // The implementation plan says "Generated disclosure content per Article 50".
        // Let's Insert if not exists for today? Or just rely on Admin generation.
        // For the shortcode, real-time generation is better. The DB table might be for "Official Snapshots".
        // I will skip automatic logging on frontend render to avoid DB bloat, assuming the Table is for storing "Approved" versions.
        // But the prompt implies using the table.
        // Let's act as if this function generates the HTML for *display*, and we only log explicitly.
    }
}
