<?php
// includes/class-unify-core.php

defined('ABSPATH') || exit;

class Unify_Core {
    
    public static function run() {
        self::load_dependencies();
        self::init_hooks();
    }
    
    private static function load_dependencies() {
        require_once Unify_PLUGIN_DIR . 'includes/class-unify-database.php';
        require_once Unify_PLUGIN_DIR . 'includes/class-unify-settings.php';
        require_once Unify_PLUGIN_DIR . 'includes/gdpr/class-unify-cookie-banner.php';
        require_once Unify_PLUGIN_DIR . 'includes/gdpr/class-unify-consent-api.php';
        require_once Unify_PLUGIN_DIR . 'includes/gdpr/class-unify-dsar-form.php';
        require_once Unify_PLUGIN_DIR . 'includes/gdpr/class-unify-dsar-queue.php';
        require_once Unify_PLUGIN_DIR . 'includes/gdpr/class-unify-script-blocker.php';
        require_once Unify_PLUGIN_DIR . 'admin/class-unify-admin-ajax.php';
        require_once Unify_PLUGIN_DIR . 'includes/premium/class-unify-cookie-scanner.php';
        require_once Unify_PLUGIN_DIR . 'includes/premium/class-unify-dsar-automation.php';
        require_once Unify_PLUGIN_DIR . 'includes/nis2/class-unify-security-logger.php';
        require_once Unify_PLUGIN_DIR . 'includes/ai-act/class-unify-ai-registry.php';
        require_once Unify_PLUGIN_DIR . 'includes/ai-act/class-unify-transparency-card.php';
        require_once Unify_PLUGIN_DIR . 'includes/ai-act/class-unify-ai-detector.php';
    }
    
    private static function init_hooks() {
        Unify_Database::init();
        Unify_Settings::init();
        Unify_Consent_API::init();
        Unify_DSAR_Form::init();
        Unify_Security_Logger::init();
        Unify_AI_Registry::init();
        Unify_Transparency_Card::init();
        
        if (is_admin()) {
            Unify_Admin_Ajax::init();
            Unify_Cookie_Scanner::init();
            Unify_DSAR_Automation::init();
        }
        
        if (Unify_Settings::get_option('unify_gdpr_enabled')) {
            Unify_Cookie_Banner::init();
            Unify_Script_Blocker::init();
        }
    }
}
