<?php
// includes/class-unify-settings.php

defined('ABSPATH') || exit;

class Unify_Settings {
    
    private static $defaults = [
        'unify_gdpr_enabled' => true,
        'unify_banner_position' => 'bottom',
        'unify_banner_theme' => 'light',
        'unify_banner_primary_color' => '#4F46E5',
        'unify_banner_text' => 'We use cookies to improve your experience. By clicking "Accept All", you consent to our use of cookies.',
        'unify_banner_accept_text' => 'Accept All',
        'unify_banner_reject_text' => 'Reject All',
        'unify_banner_customize_text' => 'Customize',
        'unify_privacy_page_id' => 0,
        'unify_block_scripts' => true,
        // Categories stored as array
        'unify_categories' => ['necessary', 'functional', 'analytics', 'marketing'],
    ];

    public static function init() {
        add_action('admin_init', [__CLASS__, 'register_settings']);
    }
    
    public static function register_settings() {
        $settings = array_keys(self::$defaults);
        foreach ($settings as $setting) {
            register_setting('unify_gdpr_options', $setting, ['sanitize_callback' => 'sanitize_text_field']);
        }
    }
    
    public static function get_option($key) {
        $default = isset(self::$defaults[$key]) ? self::$defaults[$key] : false;
        return get_option($key, $default);
    }
}
