<?php
// includes/gdpr/class-unify-dsar-form.php

defined('ABSPATH') || exit;

class Unify_DSAR_Form {
    
    public static function init() {
        add_shortcode('unify_dsar_form', [__CLASS__, 'render_shortcode']);
        add_action('wp_ajax_unify_submit_dsar', [__CLASS__, 'ajax_submit_request']);
        add_action('wp_ajax_nopriv_unify_submit_dsar', [__CLASS__, 'ajax_submit_request']);
        add_action('wp_ajax_unify_verify_dsar', [__CLASS__, 'ajax_verify_code']);
        add_action('wp_ajax_nopriv_unify_verify_dsar', [__CLASS__, 'ajax_verify_code']);
    }

    public static function render_shortcode($atts) {
        ob_start();
        include Unify_PLUGIN_DIR . 'public/views/dsar-form.php';
        return ob_get_clean();
    }
    
    public static function ajax_submit_request() {
        check_ajax_referer('unify_dsar_nonce', 'unify_dsar_nonce');
        
        $email = sanitize_email($_POST['email']);
        $type = sanitize_text_field($_POST['request_type']);
        $message = sanitize_textarea_field($_POST['message']);
        
        if (!is_email($email)) {
            wp_send_json_error(['message' => 'Invalid email address']);
        }
        
        // Generate verification code
        $code = wp_rand(100000, 999999);
        $expiry = current_time('Y-m-d H:i:s', strtotime('+15 minutes'));
        
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        
        $wpdb->insert($table, [
            'email' => $email,
            'request_type' => $type,
            'status' => 'pending',
            'message' => $message,
            'verification_code' => $code,
            'verification_expires' => $expiry,
            'submitted_date' => current_time('mysql'),
        ]);
        
        $request_id = $wpdb->insert_id;
        
        // Send email (Mocked for local env if no mailer, but code assumes standard wp_mail)
        /* translators: %s: Site name */
        $subject = sprintf(__('Verify your data request on %s', 'unify-compliance'), get_bloginfo('name'));
        /* translators: %s: Verification code */
        $body = sprintf(__('Your verification code is: %s. This code expires in 15 minutes.', 'unify-compliance'), $code);
        wp_mail($email, $subject, $body);
        
        wp_send_json_success(['message' => 'Verification code sent to ' . $email, 'request_id' => $request_id]);
    }
    
    public static function ajax_verify_code() {
        check_ajax_referer('unify_dsar_nonce', 'unify_dsar_nonce');
        $id = absint($_POST['request_id']);
        $code = sanitize_text_field($_POST['code']);
        
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        
        $req = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $id));
        
        if (!$req) {
            wp_send_json_error(['message' => 'Request not found']);
        }
        
        if ($req->verification_code !== $code) {
             wp_send_json_error(['message' => 'Invalid code']);
        }
        
        $wpdb->update($table, ['status' => 'verified', 'verified_date' => current_time('mysql')], ['id' => $id]);
        
        wp_send_json_success(['message' => 'Request verified! We will process it shortly.']);
    }
}
