<?php
// includes/gdpr/class-unify-dsar-queue.php

defined('ABSPATH') || exit;

class Unify_DSAR_Queue {
    
    public static function get_requests($status = 'all', $per_page = 20, $page = 1) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        
        $offset = ($page - 1) * $per_page;
        $where = "WHERE 1=1";
        
        if ($status !== 'all') {
            $where .= $wpdb->prepare(" AND status = %s", $status);
        }
        
        
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
        $requests = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table $where ORDER BY submitted_date DESC LIMIT %d OFFSET %d", $per_page, $offset));
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safe, comes from $wpdb->prefix
        $total = $wpdb->get_var("SELECT COUNT(*) FROM $table $where");
        
        return [
            'data' => $requests,
            'total' => $total,
            'pages' => ceil($total / $per_page)
        ];
    }
    
    public static function count_by_status() {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        $results = $wpdb->get_results("SELECT status, COUNT(*) as count FROM $table GROUP BY status");
        
        $counts = ['all' => 0, 'pending' => 0, 'verified' => 0, 'processing' => 0, 'completed' => 0, 'rejected' => 0];
        foreach($results as $row) {
            if(isset($counts[$row->status])) {
                $counts[$row->status] = (int)$row->count;
            }
            $counts['all'] += (int)$row->count;
        }
        return $counts;
    }
    
    
    public static function update_status($id, $status) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        $full_status = ['completed', 'rejected'];
        
        $data = ['status' => $status];
        if (in_array($status, $full_status)) {
            $data['completed_date'] = current_time('mysql');
            $data['completed_by'] = get_current_user_id();
        }
        
        return $wpdb->update($table, $data, ['id' => $id]);
    }
    
    /**
     * Count requests by specific status (helper for dashboard)
     *
     * @param string $status Status to count
     * @return int Count of requests
     */
    public static function count_by_status_single($status) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        return (int) $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $table WHERE status = %s", $status));
    }
    
    /**
     * Count all requests (helper for dashboard)
     *
     * @return int Total count
     */
    public static function count_all() {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        return (int) $wpdb->get_var("SELECT COUNT(*) FROM $table");
    }
}
