<?php
// includes/nis2/class-unify-log-cleanup.php

defined('ABSPATH') || exit;

class Unify_Log_Cleanup {
    
    public static function init() {
        add_action('unify_daily_log_cleanup', [__CLASS__, 'cleanup_logs']);
    }
    
    public static function schedule_events() {
        if (!wp_next_scheduled('unify_daily_log_cleanup')) {
            wp_schedule_event(time(), 'daily', 'unify_daily_log_cleanup');
        }
    }
    
    public static function unschedule_events() {
        $timestamp = wp_next_scheduled('unify_daily_log_cleanup');
        if ($timestamp) {
            wp_unschedule_event($timestamp, 'unify_daily_log_cleanup');
        }
    }
    
    public static function cleanup_logs() {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_security_logs';
        
        $retention_days = absint(get_option('unify_nis2_log_retention', 90));
        
        // Safety check: ensure retention is at least 1 day
        if ($retention_days < 1) $retention_days = 90;
        
        $date_limit = current_time('Y-m-d H:i:s', strtotime("-$retention_days days"));
        
        // Count logs to be deleted (for logging purposes)
        $count = $wpdb->get_var($wpdb->prepare(
            "SELECT COUNT(*) FROM $table WHERE created_at < %s",
            $date_limit
        ));
        
        if ($count > 0) {
            $deleted = $wpdb->query($wpdb->prepare(
                "DELETE FROM $table WHERE created_at < %s",
                $date_limit
            ));
            
            if ($deleted !== false) {
                // Log this cleanup action itself (Meta-logging)
                // We use a separate dedicated connection or just standard logging, 
                // assuming the log insertion happens AFTER this delete or is unaffected by the delete criteria (it is, since it's 'now')
                Unify_Security_Logger::log(
                    'system_cleanup', 
                    sprintf('Automatic cleanup: Deleted %d logs older than %d days.', $deleted, $retention_days), 
                    'info'
                );
            }
        }
    }
}
