<?php
// includes/nis2/class-unify-policy-manager.php

defined('ABSPATH') || exit;

class Unify_Policy_Manager {
    
    public static function get_policies($args = []) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_policies';
        
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching -- Table name is safe, comes from $wpdb->prefix
        return $wpdb->get_results("SELECT * FROM $table ORDER BY last_updated DESC");
    }
    
    public static function get_policy($id) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_policies';
        return $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $id));
    }
    
    public static function create_policy($data) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_policies';
        
        $defaults = [
            'title' => '',
            'content' => '',
            'version' => '1.0',
            'status' => 'draft',
            'updated_by' => get_current_user_id(),
            'last_updated' => current_time('mysql')
        ];
        
        $data = wp_parse_args($data, $defaults);
        
        $inserted = $wpdb->insert($table, [
            'title' => sanitize_text_field($data['title']),
            'content' => wp_kses_post($data['content']),
            'version' => sanitize_text_field($data['version']),
            'status' => sanitize_text_field($data['status']),
            'updated_by' => $data['updated_by'],
            'last_updated' => $data['last_updated']
        ]);
        
        if ($inserted) {
            Unify_Security_Logger::log('policy_created', "Created policy: {$data['title']}", 'info');
            return $wpdb->insert_id;
        }
        return false;
    }
    
    public static function update_policy($id, $data) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_policies';
        
        $existing = self::get_policy($id);
        if (!$existing) return false;
        
        // Auto-increment version if content changes? Simple approach: User sets version manually or we append .1
        // For PRD Basic reqs, we trust the input version.
        
        $data['last_updated'] = current_time('mysql');
        $data['updated_by'] = get_current_user_id();
        
        $updated = $wpdb->update($table, [
            'title' => sanitize_text_field($data['title']),
            'content' => wp_kses_post($data['content']),
            'version' => sanitize_text_field($data['version']),
            'status' => sanitize_text_field($data['status']),
            'updated_by' => $data['updated_by'],
            'last_updated' => $data['last_updated']
        ], ['id' => $id]);
        
        if ($updated !== false) {
             Unify_Security_Logger::log('policy_updated', "Updated policy: {$data['title']} (v{$data['version']})", 'info');
             return true;
        }
        return false;
    }
    
    public static function delete_policy($id) {
        global $wpdb;
        $table = $wpdb->prefix . 'unify_policies';
        
        $policy = self::get_policy($id);
        if ($policy) {
            $deleted = $wpdb->delete($table, ['id' => $id]);
            if ($deleted) {
                Unify_Security_Logger::log('policy_deleted', "Deleted policy: {$policy->title}", 'warning');
                return true;
            }
        }
        return false;
    }
}
