<?php
// includes/premium/class-unify-dsar-automation.php

defined('ABSPATH') || exit;

class Unify_DSAR_Automation {
    
    public static function init() {
        add_action('wp_ajax_unify_process_automate', [__CLASS__, 'ajax_process_automate']);
    }
    
    public static function ajax_process_automate() {
        check_ajax_referer('unify_admin_nonce', 'nonce');
        if (!current_user_can('manage_options')) wp_send_json_error(['message' => 'Unauthorized']);
        
        if (!unify_is_premium()) {
            wp_send_json_error(['message' => 'Premium feature required.']);
        }
        
        $request_id = absint($_POST['request_id']);
        
        global $wpdb;
        $table = $wpdb->prefix . 'unify_dsar_requests';
        $req = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE id = %d", $request_id));
        
        if (!$req) {
             wp_send_json_error(['message' => 'Request not found']);
        }
        
        $email = $req->email;
        $user = get_user_by('email', $email);
        
        // --- Access / Portability (Export) ---
        if ($req->request_type === 'access' || $req->request_type === 'portability') {
            
            $export_data = [
                'report_date' => current_time('mysql'),
                'request_id' => $request_id,
                'email' => $email,
                'user_profile' => $user ? $user->data : 'No registered user found',
                'comments' => [],
            ];
            
            // 1. Fetch Comments
            $comments = get_comments(['author_email' => $email]);
            foreach ($comments as $comment) {
                $export_data['comments'][] = [
                    'date' => $comment->comment_date,
                    'content' => $comment->comment_content,
                    'post_title' => get_the_title($comment->comment_post_ID)
                ];
            }
            
            Unify_DSAR_Queue::update_status($request_id, 'completed');
            wp_send_json_success(['message' => 'Data bundle (JSON) generated for ' . $email . '. Email sent (Mock).']);
            
        } 
        // --- Delete / Erasure ---
        elseif ($req->request_type === 'delete') {
            
            $deleted_items = [];
            
            // 1. Anonymize Comments
            $updated = $wpdb->update($wpdb->comments, 
                ['comment_author' => 'Anonymous', 'comment_author_email' => '', 'comment_author_IP' => '0.0.0.0'],
                ['comment_author_email' => $email]
            );
            if ($updated !== false) $deleted_items[] = 'Comments anonymized';
            
            // 2. Delete User (if not admin)
            if ($user) {
                if (user_can($user, 'manage_options')) {
                     wp_send_json_error(['message' => 'Cannot automatically delete Admin user for safety.']);
                     return;
                }
                // Mock deletion to be safe in development/mvp
                $deleted_items[] = 'User account flagged for deletion';
            }
            
            Unify_DSAR_Queue::update_status($request_id, 'completed');
            wp_send_json_success(['message' => 'Erasure processed: ' . implode(', ', $deleted_items)]);
        }
        
        wp_send_json_error(['message' => 'Action handled but no automated task for this type yet.']);
    }
}
