<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
// public/views/cookie-banner.php
// Variables: $banner_text, $position, $theme, $primary_color, $accept_text, $reject_text, $customize_text

$pos_class = ($position === 'top') ? 'unify-pos-top' : 'unify-pos-bottom';
$theme_class = ($theme === 'dark') ? 'unify-theme-dark' : 'unify-theme-light';

$privacy_page_id = Unify_Settings::get_option('unify_privacy_page_id');
$privacy_url = $privacy_page_id ? get_permalink($privacy_page_id) : get_privacy_policy_url();

// Check if WCAG mode is enabled (Premium feature)
$wcag_enabled = class_exists('Unify_Cookie_Banner') && method_exists('Unify_Cookie_Banner', 'is_wcag_mode_enabled') 
    ? Unify_Cookie_Banner::is_wcag_mode_enabled() 
    : false;
$wcag_attr = $wcag_enabled ? ' data-wcag-mode="true"' : '';
?>
<div id="unify-cookie-banner" 
     class="<?php echo esc_attr($pos_class . ' ' . $theme_class); ?>" 
     style="--unify-primary-color: <?php echo esc_attr($primary_color); ?>;"
     role="dialog"
     aria-modal="true"
     aria-labelledby="unify-banner-title"
     aria-describedby="unify-banner-description"
     tabindex="-1"<?php echo $wcag_attr; ?>>
    <div class="unify-banner-content">
        <div class="unify-banner-text">
            <h3 id="unify-banner-title"><?php esc_html_e('We use cookies', 'unify-compliance'); ?></h3>
            <p id="unify-banner-description">
                <?php echo esc_html(wp_unslash($banner_text)); ?> 
                <?php if ( $privacy_url ) : ?>
                    <a href="<?php echo esc_url( $privacy_url ); ?>" aria-label="<?php esc_attr_e('Read our Privacy Policy (opens in current tab)', 'unify-compliance'); ?>"><?php esc_html_e('Read Privacy Policy', 'unify-compliance'); ?></a>
                <?php endif; ?>
            </p>
        </div>
        <div class="unify-banner-actions">
            <button class="unify-btn unify-btn-flat" aria-label="<?php esc_attr_e('Customize cookie preferences', 'unify-compliance'); ?>"><?php echo esc_html($customize_text); ?></button>
            <button class="unify-btn unify-btn-outline unify-btn-reject" aria-label="<?php esc_attr_e('Reject all non-essential cookies', 'unify-compliance'); ?>"><?php echo esc_html($reject_text); ?></button>
            <button class="unify-btn unify-btn-fill unify-btn-accept" aria-label="<?php esc_attr_e('Accept all cookies', 'unify-compliance'); ?>"><?php echo esc_html($accept_text); ?></button>
        </div>
    </div>
</div>
